% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SignalNoiseRatio.R
\name{SignalNoiseRatio}
\alias{SignalNoiseRatio}
\title{Calculate Signal-to-noise ratio}
\usage{
SignalNoiseRatio(
  data,
  time_dim = "year",
  member_dim = "member",
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{A numerical array with, at least, 'time_dim' and 'member_dim' 
dimensions.}

\item{time_dim}{A character string indicating the name of the time dimension
in 'data'. The default value is 'year'.}

\item{member_dim}{A character string indicating the name of the member 
dimension in 'data'. The default value is 'member'.}

\item{na.rm}{A logical value indicating whether to remove NA values during the
computation. The default value is FALSE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
An array with of the signal-to-noise ratio. It has the same dimensions
 as 'data' except 'time_dim' and 'member_dim' dimensions.
}
\description{
This function computes the signal-to-noise ratio, where the signal is the 
ensemble mean variance and the noise is the variance of the ensemble members 
about the ensemble mean (Eade et al., 2014; Scaife and Smith, 2018).
}
\examples{
exp <- array(data = runif(600), dim = c(year = 15, member = 10, lat = 2, lon = 2))
SignalNoiseRatio(exp)

}
