% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reorder.R
\name{Reorder}
\alias{Reorder}
\title{Reorder the dimension of an array}
\usage{
Reorder(data, order)
}
\arguments{
\item{data}{An array of which the dimensions to be reordered.}

\item{order}{A vector of indices or character strings indicating the new 
order of the dimensions.}
}
\value{
An array which has the same values as parameter 'data' but with 
 different dimension order.
}
\description{
Reorder the dimensions of a multi-dimensional array. The order can be provided
either as indices or the dimension names. If the order is dimension name, 
the function looks for names(dim(x)). If it doesn't exist, the function checks
if attributes "dimensions" exists; this attribute is in the objects generated
by Load().
}
\examples{
 dat1 <- array(c(1:30), dim = c(dat = 1, sdate = 3, ftime = 2, lon = 5))
 print(dim(Reorder(dat1, c(2, 1, 4, 3))))
 print(dim(Reorder(dat1, c('sdate', 'dat', 'lon', 'ftime'))))
 dat2 <- array(c(1:10), dim = c(2, 1, 5))
 print(dim(Reorder(dat2, c(2, 1, 3))))
 attr(dat2, 'dimensions') <- c('sdate', 'time', 'region')
 dat2_reorder <- Reorder(dat2, c('time', 'sdate', 'region'))
 # A character array
 dat3 <- array(paste0('a', 1:24), dim = c(b = 2, c = 3, d = 4))
 dat3_reorder <- Reorder(dat3, c('d', 'c', 'b'))
}
