% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ano.R
\name{Ano}
\alias{Ano}
\title{Compute forecast or observation anomalies}
\usage{
Ano(data, clim, ncores = NULL)
}
\arguments{
\item{data}{A numeric array with named dimensions, representing the model or
observational data to be calculated the anomalies. It should involve all
the dimensions in parameter 'clim', and it can have more other dimensions.}

\item{clim}{A numeric array with named dimensions, representing the 
climatologies to be deducted from parameter 'data'. It can be generated by 
Clim(). The dimensions should all be involved in parameter 'data' with the
same length.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
An array with same dimensions as parameter 'data'.
}
\description{
This function computes anomalies from a multidimensional data array and a 
climatology array.
}
\examples{
# Load sample data as in Load() example:
example(Load)
clim <- Clim(sampleData$mod, sampleData$obs)
ano_exp <- Ano(sampleData$mod, clim$clim_exp)
ano_obs <- Ano(sampleData$obs, clim$clim_obs)
\donttest{
PlotAno(ano_exp, ano_obs, startDates, 
       toptitle = 'Anomaly', ytitle = c('K', 'K', 'K'), 
       legends = 'ERSST', biglab = FALSE, fileout = 'tos_ano.png')
}
}
