% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displayPairs.R
\name{displayPairs}
\alias{displayPairs}
\title{Display within-level pairwise comparisons for saturated two-way ANOVA model.}
\usage{
displayPairs(allpairs, levels1, levels2, brief = TRUE)
}
\arguments{
\item{allpairs}{pairwise output from a command like \code{pairs}. See details for a longer explanation.}

\item{levels1}{a character string specifying which within-level comparisons from \code{factor1} are wanted, and in which order.}

\item{levels2}{a character string specifying which within-level comparisons from \code{factor2} are wanted, and in which order.}

\item{brief}{either \code{TRUE} or \code{FALSE}. If \code{TRUE} then the information displayed will be more succinct.}
}
\description{
Displays within-level pairwise comparisons from a two-way ANOVA with
interactions.  Note that this is just a display function: it ignores any
cross-level pairs included in \code{allpairs}, even though these will have
contributed to the computations for the Tukey adjustments. The purpose is
just to organise the output from \code{emmeans} into a more convenient
format.
}
\details{
\code{allpairs} is a pairwise output from a command like
  \code{pairs(emmeans(fit, ~factor1 * factor2))}. If \code{allpairs} is not
  already a \code{data.frame} it will be converted to a \code{data.frame}
  within this function.  It must contain a column called \code{contrast} with
  text descriptions like \code{'lev1 lev2 - lev3 lev4'} etc. \code{levels1}
  and \code{levels2} are character strings specifying which within-level
  comparisons are wanted, and in which order. They must match the order
  specified in \code{emmeans}, so if using \code{emmeans(fit, ~factor1 *
  factor2)} then \code{levels1} must belong to \code{factor1} and
  \code{levels2} must belong to \code{factor2}. All this function does is to
  pick out the rows of \code{allpairs} with the requested contrasts, so if there are
  no contrasts of the requested format (e.g. because \code{levels1} and \code{levels2} have
  been switched) it will output a blank list. If \code{brief = TRUE}, columns 
  labelled \code{df}, \code{SE}, and \code{t.ratio} will be removed for a more succinct display.
}
\examples{
## Fit a two-way ANOVA to the arousal data in arousal.df.
## The factors are gender (female, male) and picture shown to 
## subject (infant, landscape, nude.f, nude.m):
data(arousal.df)
arousal.fit = lm(arousal ~ gender *  picture, data = arousal.df) 

## Create a data-frame with all pairwise comparisons using \code{emmeans}: 
require(emmeans)
arousal.allpairs = pairs(emmeans(arousal.fit,  ~gender *  picture), infer = TRUE) 

## Display only the within-level comparisons: 
displayPairs(arousal.allpairs, levels1 = c('female', 'male'), 
                               levels2 = c('infant', 'landscape', 'nude.f', 'nude.m'))
                               
}
\author{
Rachel Fewster
}
