% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_runners.R
\name{construct_runners}
\alias{construct_runners}
\title{Construct runners}
\usage{
construct_runners(
  os = c("ubuntu-latest", "macOS-latest", "windows-latest"),
  bioc = stats::setNames(list("devel", "release", "release"), os),
  r = stats::setNames(list("auto", "auto", "auto"), os),
  cont = stats::setNames(list(paste0("bioconductor/bioconductor_docker:", bioc[[1]]),
    NULL, NULL), os),
  rspm = stats::setNames(list(paste0("https://packagemanager.rstudio.com/",
    "cran/__linux__/focal/release"), NULL, NULL), os),
  versions_explicit = FALSE
)
}
\arguments{
\item{os}{Which OS to launch GitHub Actions on.}

\item{bioc}{Which Bioconductor version to use on each OS. 
See \link[rworkflows]{bioc_r_versions} documentation for all options.}

\item{r}{Which R version to use on each OS.}

\item{cont}{Which Docker container to use on each OS
(\code{NULL} means no container will be used for that OS).
See 
\href{https://hub.docker.com/r/bioconductor/bioconductor_docker/tags}{here}
 for a list of all official Bioconductor Docker container versions.}

\item{rspm}{Which R repository manager to use on each OS
(\code{NULL} means the default will be used for that OS).}

\item{versions_explicit}{Specify R/Bioc versions explicitly
(e.g. \code{r: 4.2.0, bioc: 3.16}) 
as opposed to flexibly (e.g. \code{r: "latest", bioc: "release"}).}
}
\value{
Named list of configurations for each runner OS.
}
\description{
Construct runner configurations across multiple Operating Systems (OS)
 for GitHub Actions workflow.
}
\examples{
runners <- construct_runners()
}
