% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_search.R
\name{w_search}
\alias{w_search}
\title{Search keyword inside dataset catalogue or series catalogue}
\usage{
w_search(dataset_name, keyword = "", language = "fr", client_ID,
  base_url = "https://api.webstat.banque-france.fr/webstat-",
  ignore.case = TRUE, fixed = FALSE, ...)
}
\arguments{
\item{dataset_name}{Optional. String (must be entered between quotes.) The datasets codes can be determined using the w_datasets() function.}

\item{keyword}{Optional. String or regexp you want to search}

\item{language}{Optional. String. Defaults to "fr" (French). The only other available option is "en" (English). Determines the language of the metadata. Your Webstat "App" must be subscribed to the API in this language (or both languages) or you'll get a 501 http error.}

\item{client_ID}{Optional. String. If you do not specify it when calling the function, it will check if a global variable called "webstat_client_ID" exists and use it. If not, you will be prompted. The easiest way is to save the client ID as a string in a "webstat_client_ID" global variable.}

\item{base_url}{Optional. String. Defaults to "https://api.webstat.banque-france.fr/webstat-". For internal testing purposes only.}

\item{ignore.case}{Optional. Boolean. Break case sensitivity}

\item{fixed}{Optional. Boolean. Allow or not regexp expressions}

\item{...}{Arguments to be passed to grepl function ("fixed = TRUE" if you don't want to use regexp)}
}
\value{
A dataframe
}
\description{
Search keyword inside dataset catalogue or series catalogue
}
\examples{
\dontrun{
# find Danish exchange rate code series (fr & en) : 
w_search("EXR",keyword="danoise",fixed=TRUE)
w_search("EXR",keyword="Danish",fixed=TRUE,language="en")

# find datasets with keyword :
w_search(keyword="Emploi",fixed=TRUE)
w_search(keyword="Interest Rates",language="en",fixed=TRUE)

# regexp can also be used - find series starting with "Monetary"
w_search(keyword="^Monetary",language="en")
}
}
