% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_rv.R
\name{print.rv}
\alias{print.rv}
\title{Print Distribution Summary of a Random Variable}
\usage{
\method{print}{rv}(x, digits = rvpar("print.digits"), ...)
}
\arguments{
\item{x}{an rv object}

\item{digits}{minimal number of significant digits}

\item{\dots}{further arguments passed to or from other methods}
}
\description{
Prints a summary of the random variable object.
}
\details{
Invokes first the summary method of the object, then prints the result.
}
\examples{

  print(rvnorm(mean = rvnorm(1)))

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{rvfactor}}
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
