% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{max_run}
\alias{max_run}
\title{Running maximum}
\usage{
max_run(
  x,
  k = integer(0),
  lag = integer(1),
  idx = integer(0),
  at = integer(0),
  na_rm = TRUE,
  na_pad = FALSE
)
}
\arguments{
\item{x}{Vector of any type}

\item{k}{(\code{integer}) vector or single value denoting size of the running
window. If \code{k} is a single value then window size is constant for all
elements, otherwise if \code{length(k) == length(x)} different window size
for each element.}

\item{lag}{(\code{integer}) vector or single value denoting window lag.
If \code{lag} is a single value then window lag is constant for all elements,
otherwise if \code{length(lag) == length(x)} different window size for each
element. Negative value shifts window forward.}

\item{idx}{(\code{date or integer}) an optional integer vector containing
index of observation. If specified
then \code{k} and \code{lag} are depending on \code{idx}. Length of
\code{idx} should be equal of length \code{x}}

\item{at}{(\code{date or integer}) vector of any size and any value
defining output data points. Values of the vector defines the indexes which
data is computed at. If \code{idx} is missing then uses indices from \code{1}
 to \code{length(x)}, otherwise depends on indexes passed with \code{idx}.
 If \code{at} is defined then \code{k} and \code{lag} should be of length equal
 one or length of the \code{at}.}

\item{na_rm}{\code{logical} single value (default \code{na_rm = TRUE}) -
if \code{TRUE} sum is calculating excluding \code{NA}.}

\item{na_pad}{\code{logical} single value (default \code{na_pad=FALSE}) - if
\code{TRUE} calculation on incomplete window will return \code{NA}.
Incomplete window is when some parts of the window are out of range}
}
\value{
max {numeric} vector of length equals length of \code{x}.
}
\description{
\code{min_run} calculates running max on given \code{x} numeric vector,
specified \code{k} window size.
}
\examples{
set.seed(11)
x1 <- sample( c(1,2,3), 15, replace=TRUE)
x2 <- sample( c(NA,1,2,3), 15, replace=TRUE)
k  <- sample( 1:4, 15, replace=TRUE)
max_run(x1) # simple cumulative maximum
max_run(x2, na_rm = TRUE) # cumulative maximum with removing NA.
max_run(x2, na_rm = TRUE, k=4) # maximum in 4-element window
max_run(x2, na_rm = FALSE, k=k) # maximum in varying k window size
}
