% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{streak_run}
\alias{streak_run}
\title{Running streak length}
\usage{
streak_run(x, k = 0L, na_rm = TRUE, na_pad = FALSE, idx = 1L)
}
\arguments{
\item{x}{vector of any type where running streak is calculated}

\item{k}{running window size. By default window size equals \code{length(x)}. Allow varying window size specified by vector of \code{length(x)}}

\item{na_rm}{logical (default \code{na_rm=TRUE}) - if \code{TRUE} \code{NA} are replaced by last observed streak prior to element.}

\item{na_pad}{logical (default \code{na_pad=FALSE}) - if \code{TRUE} first k-results will be filled by \code{NA}. If k is not specified na_pad=F by default.}

\item{idx}{an optional integer vector containing indexes numbers of observation.}
}
\value{
numeric vector of length equals length of \code{x} containing running streak length in \code{k}-long window.
}
\description{
Calculates running series of consecutive elements
}
\examples{
set.seed(11)
x1 <- sample(c("a","b"),15,replace=TRUE)
x2 <- sample(c(NA_character_,"a","b"),15,replace=TRUE)
k <- sample(1:4,15,replace=TRUE)
streak_run(x1) # simple streak run
streak_run(x1, k=2) # streak run within 2-element window
streak_run(x2, na_pad=TRUE, k=3) # streak run within k=3 with padding NA
streak_run(x1, k=k) # streak run within varying window size specified by vector k
}
