% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lists_members.R
\name{lists_members}
\alias{lists_members}
\title{Get Twitter list members (users on a given list).}
\usage{
lists_members(
  list_id = NULL,
  slug = NULL,
  owner_user = NULL,
  n = 5000,
  cursor = "-1",
  token = NULL,
  retryonratelimit = NULL,
  verbose = TRUE,
  parse = TRUE,
  ...
)
}
\arguments{
\item{list_id}{required The numerical id of the list.}

\item{slug}{required You can identify a list by its slug instead of
its numerical id. If you decide to do so, note that you'll also
have to specify the list owner using the owner_id or
owner_user parameters.}

\item{owner_user}{optional The screen name or user ID of the user}

\item{n}{Desired number of results to return. Results are downloaded
in pages when \code{n} is large; the default value will download a single
page. Set \code{n = Inf} to download as many results as possible.

The Twitter API rate limits the number of requests you can perform
in each 15 minute period. The easiest way to download more than that is
to use \code{retryonratelimit = TRUE}.

You are not guaranteed to get exactly \code{n} results back. You will get
fewer results when tweets have been deleted or if you hit a rate limit.
You will get more results if you ask for a number of tweets that's not
a multiple of page size, e.g. if you request \code{n = 150} and the page
size is 200, you'll get 200 results back.}

\item{cursor}{Which page of results to return. The default will return
the first page; you can supply the result from a previous call to
continue pagination from where it left off.}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{retryonratelimit}{If \code{TRUE}, and a rate limit is exhausted, will wait
until it refreshes. Most Twitter rate limits refresh every 15 minutes.
If \code{FALSE}, and the rate limit is exceeded, the function will terminate
early with a warning; you'll still get back all results received up to
that point. The default value, \code{NULL}, consults the option
\code{rtweet.retryonratelimit} so that you can globally set it to \code{TRUE},
if desired.

If you expect a query to take hours or days to perform, you should not
rely soley on \code{retryonratelimit} because it does not handle other common
failure modes like temporarily losing your internet connection.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{...}{Other arguments used as parameters in query composition.}
}
\description{
Get Twitter list members (users on a given list).
}
\examples{
if (auth_has_default()) {

## get list members for a list of rstats experts using list_id
(rstats <- lists_members("785434502382383105"))

## get list members for an rstats list using list topic slug
## list owner's screen name
rstats <- lists_members(slug = "rstats", owner_user = "scultrera")
rstats

}

}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/create-manage-lists/api-reference/get-lists-members}
}
\seealso{
Other lists: 
\code{\link{lists_statuses}()},
\code{\link{lists_subscribers}()},
\code{\link{lists_subscriptions}()},
\code{\link{lists_users}()}
}
\concept{lists}
