% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retweets.R
\name{get_retweets}
\alias{get_retweets}
\title{Get the most recent retweets of a specific Twitter status}
\usage{
get_retweets(status_id, n = 100, parse = TRUE, token = NULL, ...)
}
\arguments{
\item{status_id}{required The numerical ID of the desired status.}

\item{n}{optional Specifies the number of records to retrieve.
Must be less than or equal to 100.}

\item{parse}{Logical indicating whether to convert the response
object into an R list. Defaults to TRUE.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}

\item{...}{Other arguments used as parameters in the query sent to
Twitter's rest API, for example, \code{trim_user = TRUE}.}
}
\value{
Tweets data of the most recent retweets of a given status
}
\description{
Returns a collection of the 100 most recent retweets of a given
status.  NOTE: Twitter's API is currently limited to 100 or fewer
retweeters.
}
\details{
NOTE: Twitter's API is currently limited to 100 or fewer
  retweeters.
}
\seealso{
Other retweets: \code{\link{get_retweeters}}
}
\concept{retweets}
