% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trends.R
\name{get_trends}
\alias{get_trends}
\title{get_trends}
\usage{
get_trends(woeid = 1, exclude = FALSE, token = NULL, parse = TRUE)
}
\arguments{
\item{woeid}{Numeric, WOEID (Yahoo! Where On Earth ID) or
character string of desired town or country. To browse all
available trend places, see \code{\link{trends_available}}}

\item{exclude}{Logical, indicating whether or not to exclude
hashtags}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}

\item{parse}{Logical, indicating whether or not to parse return
trends data.}
}
\value{
Trend data for a given location.
}
\description{
Returns Twitter trends
}
\examples{
\dontrun{
# Retrieve available trends
trends <- available_trends()
trends

# Store WOEID for Worldwide trends
worldwide <- subset(trends, name == "Worldwide")[["woeid"]]

# Retrieve worldwide trends datadata
ww_trends <- get_trends(woeid = worldwide)

# Preview trends data
ww_trends
}

}
\seealso{
Other trends: \code{\link{find_woeid}},
  \code{\link{trends_available}}
}

