% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeline.R
\name{get_timeline}
\alias{get_timeline}
\title{get_timeline}
\usage{
get_timeline(user, n = 200, max_id = NULL, parse = TRUE, token = NULL,
  ...)
}
\arguments{
\item{user}{Screen name or user id of target user.}

\item{n}{Numeric, number of tweets to return.}

\item{max_id}{Character, status_id from which returned tweets
should be older than}

\item{parse}{Logical, indicating whether to return parsed
(data.frames) or nested list (fromJSON) object. By default,
\code{parse = TRUE} saves users from the time
[and frustrations] associated with disentangling the Twitter
API return objects.}

\item{token}{OAuth token (1.0 or 2.0). By default
\code{token = NULL} fetches a non-exhausted token from
an environment variable.}

\item{\dots}{Other arguments passed on to \code{make_url}.}
}
\value{
List consisting of two data frames. One with the tweets
  data for a specified user and the second is a single row for
  the user provided.
}
\description{
Returns timeline of tweets from a specified
  Twitter user.
}
\seealso{
\url{https://dev.twitter.com/overview/documentation}
}

