% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot.corner.label}
\alias{rtsplot.corner.label}
\title{Plot corner label}
\usage{
rtsplot.corner.label(label = NULL, col = "black", x = -1, y = 1,
  xoffset = NA, yoffset = NA, space = c("plot", "figure"), cex = 1,
  border = NA)
}
\arguments{
\item{label}{label}

\item{col}{label color}

\item{x}{x location, \strong{defaults to -1}}

\item{y}{y location, \strong{defaults to 1}}

\item{xoffset}{x offset, \strong{defaults to NA}}

\item{yoffset}{y offset, \strong{defaults to NA}}

\item{space}{coordinate space, can be "plot" or "figure", \strong{defaults to "plot"}}

\item{cex}{font size, \strong{defaults to 1}}

\item{border}{border color, \strong{defaults to NA - no color}}
}
\value{
nothing
}
\description{
Plot corner label, based on the [text at the upper left corner outside of the plot region](http://r.789695.n4.nabble.com/text-at-the-upper-left-corner-outside-of-the-plot-region-td885675.html)
}
\examples{
 rtsplot.theme.set(legend.bg.col=grDevices::adjustcolor('orange', 200/255))
 plot(rnorm(20), rnorm(20))

 rtsplot.corner.label('test1', y=-1, space='figure')
 rtsplot.corner.label('test2', y=1, space='figure')
 rtsplot.corner.label('test3', x=1, space='figure')
 rtsplot.corner.label('test4', x=1, y=-1, space='figure')
 rtsplot.theme.set(legend.bg.col=grDevices::adjustcolor('white', 50/255))

}
