% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arr_3d.R
\name{apply_col}
\alias{apply_col}
\alias{apply_row}
\title{apply_col}
\usage{
apply_col(mat, by, FUN = colMeans2, scale = 1, ...)

apply_row(mat, by, FUN = rowMeans2, scale = 1, ...)
}
\arguments{
\item{mat}{matrix, \verb{[nrow, ncol]}}

\item{by}{integer vector, with the dim of \verb{[ntime]}}

\item{scale}{in the same length of \code{by}, or a const value,
\code{value_returned} = \code{FUN(x)*scale}. This parameter is designed for converting
monthly to yearly, meanwhile multiply days in month.
Currently, same group should have the same scale factor. Otherwise, only the
first is used.}
}
\description{
\itemize{
\item \code{apply_col}: aggregate by col, return a \verb{[ngrp, ncol]} matrix
\item \code{apply_row}: aggregate by row, return a \verb{[nrow, ngrp]} matrix
}
}
\details{
For example, setting the dimension of \code{mat} is \verb{[ngrid, ntime]},
if you want to aggregate by time, \code{apply_row} should be used here;
if you want to aggregate by region (grids), \code{apply_col} should be used.
}
\note{
This function also suits for big.matrix object.
}
\examples{
mat <- matrix(rnorm(4 * 6), 4, 6)
mat_bycol <- apply_col(mat, c(1, 1, 2, 2), colMeans)
mat_byrow <- apply_row(mat, c(1, 1, 2, 2, 3, 3), rowMeans)

}
\keyword{internal}
