% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cg_billscosponsor.R
\name{cg_billscosponsor}
\alias{cg_billscosponsor}
\title{Get bill cosponsorship data for a particular member.}
\usage{
cg_billscosponsor(memberid = NULL, type = NULL, key = NULL, ...)
}
\arguments{
\item{memberid}{The member's unique ID number (alphanumeric). To find a
member's ID number, get the list of members for the appropriate House
or Senate. You can also use the Biographical Directory of the United
States Congress to get a member's ID. In search results, each member's
name is linked to a record by index ID (e.g.,
http://bioguide.congress.gov/scripts/biodisplay.pl?index=C001041).
Use the index ID as member-id in your request.}

\item{type}{One of 'cosponsored' (the 20 bills most recently cosponsored
by member-id) or 'withdrawn' (the 20 most recently withdrawn
cosponsorships for member-id).}

\item{key}{your New York Times API key; pass in, or loads from .Rprofile as
\code{nytimes_cg_key}, or from .Renviron as \code{NYTIMES_CG_KEY}}

\item{...}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\value{
List of new members of he current Congress.
}
\description{
Get bill cosponsorship data for a particular member.
}
\examples{
\dontrun{
cg_billscosponsor(memberid='S001181', type='cosponsored')
}
}

