% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{log_lik.stapreg}
\alias{log_lik.stapreg}
\alias{log_lik}
\title{Pointwise log-likelihood matrix}
\usage{
\method{log_lik}{stapreg}(object, newsubjdata = NULL,
  newdistdata = NULL, newtimedata = NULL, offset = NULL, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstap} modeling functions. See \code{\link{stapreg-objects}}.}

\item{newsubjdata}{Optionally, a data frame of the subject-specific data
in which to look for variables with which to predict.
If omitted, the original datasets are used. If \code{newsubjdata}
is provided and any variables were transformed (e.g. rescaled) in the data
used to fit the model, then these variables must also be transformed in
\code{newsubjdata}.  Also see the Note
section below for a note about using the \code{newsubjdata} argument with with
binomial models.}

\item{newdistdata}{If newsubjdata is provided a data frame of the subject-distance
must also be given for models with a spatial component - can be the same as original distance_dataframe}

\item{newtimedata}{If newsubjdata is provided, a data frame of the subject-time data
must also be given for models with a temporal component}

\item{offset}{A vector of offsets. Only required if \code{newsubjdata} is
specified and an \code{offset} was specified when fitting the model.}

\item{...}{Currently ignored.}
}
\value{
A \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size of the posterior  
  sample and \eqn{N} is the number of data points.
}
\description{
For models fit using MCMC, the \code{log_lik} method returns the
\eqn{S} by \eqn{N} pointwise log-likelihood matrix, where \eqn{S} is the size
of the posterior sample and \eqn{N} is the number of data points.
}
