% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatures.R
\name{sign_planetary_computer}
\alias{sign_planetary_computer}
\title{Signature in hrefs provided by the STAC from Microsoft's Planetary
Computer.}
\usage{
sign_planetary_computer(..., token_url = NULL)
}
\arguments{
\item{...}{additional parameters can be supplied to the \code{GET} function
of the \code{httr} package.}

\item{token_url}{a \code{character} with the URL that generates the tokens
in the Microsoft service.
By default is used:
\code{"https://planetarycomputer.microsoft.com/api/sas/v1/token"}}
}
\value{
a \code{function} that signs each item assets.
}
\description{
To perform the signing of the hrefs a request is sent to
Planetary Computer servers and the returned content corresponds to the
token that will be used in the href.
}
\examples{
\dontrun{
# STACItemCollection object
stac_obj <- stac("https://planetarycomputer.microsoft.com/api/stac/v1/") \%>\%
 stac_search(collections = "sentinel-2-l2a",
             bbox = c(-47.02148, -42.53906, -12.98314, -17.35063)) \%>\%
 get_request()

# signing each item href
stac_obj \%>\% items_sign(sign_fn = sign_planetary_computer())

}

}
