% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stac.R
\name{stac}
\alias{stac}
\title{Endpoint functions}
\usage{
stac(base_url, force_version = NULL)
}
\arguments{
\item{base_url}{a \code{character} informing the base url of a
STAC web service.}

\item{force_version}{a \code{character} providing the version of the stac
used. If not provided, the rstac package will make requests to try to find
the version of STAC used. It is highly recommended that you inform the STAC
version you are using.}
}
\value{
A \code{RSTACQuery} object with the subclass \code{stac} containing all
request parameters to be provided to API service.
}
\description{
The \code{stac} function implements \code{/stac} API
endpoint (>=0.8.0). It prepares search fields parameters to be provided to
a STAC API web service. This endpoint should return a STAC Catalog document
containing all published data catalogs.
}
\examples{
\donttest{
stac("http://brazildatacube.dpi.inpe.br/stac/") \%>\%
  get_request()
}

}
\seealso{
\code{\link{stac_search}}, \code{\link{collections}},
\code{\link{items}}, \code{\link{get_request}},
\code{\link{post_request}}
}
