library(rslp)
context("rslp")
steprules <- readRDS(system.file("steprules.rds", package = "rslp"))

test_that("rslp works fine", {
  expect_equal(rslp::rslp("bons"), "bom")
  expect_equal(rslp::rslp("bal\u00f5es"), "bal")
  expect_equal(rslp::rslp("capit\u00e3es"), "capita")
  expect_equal(rslp::rslp("normais"), "norm")
  expect_equal(rslp::rslp("am\u00e1veis"), "am")
  expect_equal(rslp::rslp("len\u00e7\u00f3is"), "lencol")
  expect_equal(rslp::rslp("barris"), "barril")
  expect_equal(rslp::rslp("males"), "mal")
  expect_equal(rslp::rslp("mares"), "mar")
  expect_equal(rslp::rslp("casas"), "cas")
  expect_equal(rslp::rslp("chefona"), "chef")
  expect_equal(rslp::rslp("vil\u00e3"), "vila")
  expect_equal(rslp::rslp("professora"), "profes")
  expect_equal(rslp::rslp("americana"), "americ")
  expect_equal(rslp::rslp("chilena"), "chilen")
  expect_equal(rslp::rslp("inglesa"), "ingl")
  expect_equal(rslp::rslp("famosa"), "fam")
  expect_equal(rslp::rslp("man\u00edaca"), "man")
  expect_equal(rslp::rslp("pr\u00e1tica"), "prat")
  expect_equal(rslp::rslp("mantida"), "mant")
  expect_equal(rslp::rslp("cansada"), "cans")
  expect_equal(rslp::rslp("prima"), "prim")
  expect_equal(rslp::rslp("passiva"), "passiv")
  expect_equal(rslp::rslp("primeira"), "prim")
  expect_equal(rslp::rslp("sozinha"), "so")
  expect_equal(rslp::rslp("felizmente"), "feliz")
  expect_equal(rslp::rslp("cansad\u00edssimo"), "cans")
  # expect_equal(rslp::rslp("amabil\u00edssimo"), "ama")
  expect_equal(rslp::rslp("fort\u00edssimo"), "fort")
  expect_equal(rslp::rslp("chiqu\u00e9rrimo"), "chiqu")
  expect_equal(rslp::rslp("pezinho"), "pe")
  expect_equal(rslp::rslp("maluquinho"), "maluc")
  expect_equal(rslp::rslp("amiguinho"), "amig")
  expect_equal(rslp::rslp("cansadinho"), "cans")
  expect_equal(rslp::rslp("carrinho"), "carr")
  expect_equal(rslp::rslp("grandalh\u00e3o"), "grand")
  #expect_equal(rslp::rslp("dentu\u00e7a"), "dent") # ver pq não funciona
  expect_equal(rslp::rslp("mulhera\u00e7o"), "mulh")
  expect_equal(rslp::rslp("cansad\u00e3o"), "cans")
  expect_equal(rslp::rslp("corp\u00e1zio"), "corp")
  expect_equal(rslp::rslp("pratarraz"), "prat")
  #expect_equal(rslp::rslp("bocarra"), "boc") # ver pq não funciona
  expect_equal(rslp::rslp("calorz\u00e3o"), "cal")
  expect_equal(rslp::rslp("menin\u00e3o"), "menin")
  expect_equal(rslp::rslp("existencialista"), "exist")
  expect_equal(rslp::rslp("minimalista"), "minim")
  expect_equal(rslp::rslp("contagem"), "cont")
  expect_equal(rslp::rslp("gerenciamento"), "gerenc")
  expect_equal(rslp::rslp("monitoramento"), "monitor") # diferente do artigo que est\u00e1 errado
  expect_equal(rslp::rslp("nascimento"), "nasc")
  expect_equal(rslp::rslp("comercializado"), "comerci")
  expect_equal(rslp::rslp("traumatizado"), "traum")
  expect_equal(rslp::rslp("alfabetizado"), "alfabet")
  expect_equal(rslp::rslp("associativo"), "associ")
  expect_equal(rslp::rslp("contraceptivo"), "contracep")
  expect_equal(rslp::rslp("esportivo"), "espor") # diferente do artigo. o artigo est\u00e1 errado
  expect_equal(rslp::rslp("abalado"), "abal")
  expect_equal(rslp::rslp("impedido"), "imped")
  expect_equal(rslp::rslp("ralador"), "ral")
  expect_equal(rslp::rslp("entendido"), "entend")
  expect_equal(rslp::rslp("cumpridor"), "cumpr")
  expect_equal(rslp::rslp("obrigat\u00f3ria"), "obrig")
  expect_equal(rslp::rslp("produtor"), "produt")
  expect_equal(rslp::rslp("comparabilidade"), "compar")
  expect_equal(rslp::rslp("abolicionista"), "abol")
  expect_equal(rslp::rslp("intervencionista"), "interven")
  expect_equal(rslp::rslp("profissional"), "profiss")
  expect_equal(rslp::rslp("refer\u00eancia"), "refer")
  expect_equal(rslp::rslp("repugn\u00e2ncia"), "repugn")
  expect_equal(rslp::rslp("abatedouro"), "abat")
  expect_equal(rslp::rslp("fofoqueiro"), "fofoc")
  expect_equal(rslp::rslp("brasileiro"), "brasil")
  expect_equal(rslp::rslp("gostoso"), "gost")
  expect_equal(rslp::rslp("comercializa\u00e7"), "comerci")
  expect_equal(rslp::rslp("consumismo"), "consum")
  expect_equal(rslp::rslp("concretiza\u00e7\u00e3o"), "concre")
  expect_equal(rslp::rslp("alega\u00e7"), "aleg")
  expect_equal(rslp::rslp("aboli\u00e7"), "abol")
  expect_equal(rslp::rslp("anedot\u00e1rio"), "anedot")
  expect_equal(rslp::rslp("minist\u00e9rio"), "minist")
  expect_equal(rslp::rslp("chin\u00eas"), "chin")
  expect_equal(rslp::rslp("beleza"), "bel")
  expect_equal(rslp::rslp("rigidez"), "rigid")
  expect_equal(rslp::rslp("parentesco"), "parent")
  expect_equal(rslp::rslp("ocupante"), "ocup")
  expect_equal(rslp::rslp("bomb\u00e1stico"), "bomb")
  expect_equal(rslp::rslp("problem\u00e1tico"), "problem")
  expect_equal(rslp::rslp("pol\u00eamico"), "polem")
  expect_equal(rslp::rslp("produtividade"), "produt")
  expect_equal(rslp::rslp("profundidade"), "profund")
  expect_equal(rslp::rslp("aposentadoria"), "aposentad")
  expect_equal(rslp::rslp("anedot\u00e1rio"), "anedot")
  expect_equal(rslp::rslp("existencial"), "exist")
  expect_equal(rslp::rslp("artista"), "artist") #
  expect_equal(rslp::rslp("maluquice"), "maluc")
  expect_equal(rslp::rslp("chatice"), "chat")
  expect_equal(rslp::rslp("demon\u00edaco"), "demon")
  expect_equal(rslp::rslp("decorrente"), "decorr")
  expect_equal(rslp::rslp("criminal"), "crim")
  expect_equal(rslp::rslp("americano"), "americ")
  expect_equal(rslp::rslp("am\u00e1vel"), "am")
  expect_equal(rslp::rslp("combust\u00edvel"), "combust")
  expect_equal(rslp::rslp("cobertura"), "cobert")
  expect_equal(rslp::rslp("consensual"), "consens")
  expect_equal(rslp::rslp("mundial"), "mund")
  expect_equal(rslp::rslp("experimental"), "experiment")
  expect_equal(rslp::rslp("cantar\u00edamo"), "cant")
  expect_equal(rslp::rslp("cant\u00e1ssemo"), "cant")
  expect_equal(rslp::rslp("beber\u00edamo"), "beb")
  expect_equal(rslp::rslp("beb\u00eassemo"), "beb")
  expect_equal(rslp::rslp("partir\u00edamo"), "part")
  expect_equal(rslp::rslp("part\u00edssemo"), "part")
  expect_equal(rslp::rslp("cant\u00e1ramo"), "cant")
  expect_equal(rslp::rslp("cant\u00e1rei"), "cant")
  expect_equal(rslp::rslp("cantaremo"), "cant")
  expect_equal(rslp::rslp("cantariam"), "cant")
  expect_equal(rslp::rslp("cantar\u00edei"), "cant")
  expect_equal(rslp::rslp("cant\u00e1ssei"), "cant")
  expect_equal(rslp::rslp("cantassem"), "cant")
  expect_equal(rslp::rslp("cant\u00e1vamo"), "cant")
  expect_equal(rslp::rslp("beb\u00earamo"), "beb")
  expect_equal(rslp::rslp("beberemo"), "beb")
  expect_equal(rslp::rslp("beberiam"), "beb")
  expect_equal(rslp::rslp("beber\u00edei"), "beb")
  expect_equal(rslp::rslp("beb\u00eassei"), "beb")
  expect_equal(rslp::rslp("bebessem"), "beb")
  expect_equal(rslp::rslp("partir\u00edamo"), "part")
  expect_equal(rslp::rslp("partiremo"), "part")
  expect_equal(rslp::rslp("partiriam"), "part")
  expect_equal(rslp::rslp("partir\u00edei"), "part")
  expect_equal(rslp::rslp("part\u00edssei"), "part")
  expect_equal(rslp::rslp("partissem"), "part")
  expect_equal(rslp::rslp("cantando"), "cant")
  expect_equal(rslp::rslp("bebendo"), "beb")
  expect_equal(rslp::rslp("partindo"), "part")
  expect_equal(rslp::rslp("propondo"), "prop")
  expect_equal(rslp::rslp("cantaram"), "cant")
  expect_equal(rslp::rslp("cantarde"), "cant")
  expect_equal(rslp::rslp("cantarei"), "cant")
  expect_equal(rslp::rslp("cantarem"), "cant")
  expect_equal(rslp::rslp("cantaria"), "cant")
  expect_equal(rslp::rslp("cantarmo"), "cant")
  expect_equal(rslp::rslp("cantasse"), "cant")
  expect_equal(rslp::rslp("cantaste"), "cant")
  expect_equal(rslp::rslp("cantavam"), "cant")
  expect_equal(rslp::rslp("cant\u00e1vei"), "cant")
  expect_equal(rslp::rslp("beberam"), "beb")
  expect_equal(rslp::rslp("beberde"), "beb")
  expect_equal(rslp::rslp("beberei"), "beb")
  expect_equal(rslp::rslp("beb\u00earei"), "beb")
  expect_equal(rslp::rslp("beberem"), "beb")
  expect_equal(rslp::rslp("beberia"), "beb")
  expect_equal(rslp::rslp("bebermo"), "beb")
  expect_equal(rslp::rslp("bebesse"), "beb")
  expect_equal(rslp::rslp("bebeste"), "beb")
  expect_equal(rslp::rslp("beb\u00edamo"), "beb")
  expect_equal(rslp::rslp("partiram"), "part")
  expect_equal(rslp::rslp("conclu\u00edram"), "conclu")
  expect_equal(rslp::rslp("partirde"), "part")
  expect_equal(rslp::rslp("partirei"), "part")
  expect_equal(rslp::rslp("partirem"), "part")
  expect_equal(rslp::rslp("partiria"), "part")
  expect_equal(rslp::rslp("partirmo"), "part")
  expect_equal(rslp::rslp("partisse"), "part")
  expect_equal(rslp::rslp("partiste"), "part")
  expect_equal(rslp::rslp("cantamo"), "cant")
  expect_equal(rslp::rslp("cantara"), "cant")
  expect_equal(rslp::rslp("cantar\u00e1"), "cant")
  expect_equal(rslp::rslp("cantare"), "cant")
  expect_equal(rslp::rslp("cantava"), "cant")
  expect_equal(rslp::rslp("cantemo"), "cant")
  expect_equal(rslp::rslp("bebera"), "beb")
  expect_equal(rslp::rslp("beber\u00e1"), "beb")
  expect_equal(rslp::rslp("bebere"), "beb")
  expect_equal(rslp::rslp("bebiam"), "beb")
  expect_equal(rslp::rslp("beb\u00edei"), "beb")
  expect_equal(rslp::rslp("partimo"), "part")
  expect_equal(rslp::rslp("partira"), "part")
  expect_equal(rslp::rslp("partir\u00e1"), "part")
  expect_equal(rslp::rslp("partire"), "part")
  expect_equal(rslp::rslp("compomo"), "comp")
  expect_equal(rslp::rslp("cantai"), "cant")
  expect_equal(rslp::rslp("cantam"), "cant")
  expect_equal(rslp::rslp("cheguei"), "cheg")
  expect_equal(rslp::rslp("cantei"), "cant")
  expect_equal(rslp::rslp("cantem"), "cant")
  expect_equal(rslp::rslp("beber"), "beb")
  expect_equal(rslp::rslp("bebeu"), "beb")
  expect_equal(rslp::rslp("bebia"), "beb")
  expect_equal(rslp::rslp("partir"), "part")
  expect_equal(rslp::rslp("partiu"), "part")
  expect_equal(rslp::rslp("chegou"), "cheg")
  expect_equal(rslp::rslp("bebi"), "beb")
  expect_equal(rslp::rslp("menina"), "menin")
  expect_equal(rslp::rslp("grande"), "grand")
  expect_equal(rslp::rslp("menino"), "menin")
})
