library(rslp)
context("Apply Rules")
steprules <- readRDS(system.file("steprules.rds", package = "rslp"))

test_that("Plural Reduction Rules", {
  expect_equal(rslp:::apply_rules("bons", name = "Plural", steprules = steprules), "bom")
  expect_equal(rslp:::apply_rules("bal\u00f5es", name = "Plural", steprules = steprules), "bal\u00e3o")
  expect_equal(rslp:::apply_rules("capit\u00e3es", name = "Plural", steprules = steprules), "capit\u00e3o")
  expect_equal(rslp:::apply_rules("normais", name = "Plural", steprules = steprules), "normal")
  expect_equal(rslp:::apply_rules("am\u00e1veis", name = "Plural", steprules = steprules), "am\u00e1vel")
  expect_equal(rslp:::apply_rules("len\u00e7\u00f3is", name = "Plural", steprules = steprules), "len\u00e7ol")
  expect_equal(rslp:::apply_rules("barris", name = "Plural", steprules = steprules), "barril")
  expect_equal(rslp:::apply_rules("males", name = "Plural", steprules = steprules), "mal")
  expect_equal(rslp:::apply_rules("mares", name = "Plural", steprules = steprules), "mar")
  expect_equal(rslp:::apply_rules("casas", name = "Plural", steprules = steprules), "casa")
})

test_that("Feminine Reduction Rules", {
  expect_equal(rslp:::apply_rules("chefona", name = "Feminine", steprules = steprules), "chef\u00e3o")
  expect_equal(rslp:::apply_rules("vil\u00e3", name = "Feminine", steprules = steprules), "vil\u00e3o")
  expect_equal(rslp:::apply_rules("professora", name = "Feminine", steprules = steprules), "professor")
  expect_equal(rslp:::apply_rules("americana", name = "Feminine", steprules = steprules), "americano")
  expect_equal(rslp:::apply_rules("chilena", name = "Feminine", steprules = steprules), "chileno")
  expect_equal(rslp:::apply_rules("inglesa", name = "Feminine", steprules = steprules), "ingl\u00eas")
  expect_equal(rslp:::apply_rules("famosa", name = "Feminine", steprules = steprules), "famoso")
  expect_equal(rslp:::apply_rules("man\u00edaca", name = "Feminine", steprules = steprules), "man\u00edaco")
  expect_equal(rslp:::apply_rules("pr\u00e1tica", name = "Feminine", steprules = steprules), "pr\u00e1tico")
  expect_equal(rslp:::apply_rules("mantida", name = "Feminine", steprules = steprules), "mantido")
  expect_equal(rslp:::apply_rules("cansada", name = "Feminine", steprules = steprules), "cansado")
  expect_equal(rslp:::apply_rules("prima", name = "Feminine", steprules = steprules), "primo")
  expect_equal(rslp:::apply_rules("passiva", name = "Feminine", steprules = steprules), "passivo")
  expect_equal(rslp:::apply_rules("primeira", name = "Feminine", steprules = steprules), "primeiro")
  expect_equal(rslp:::apply_rules("sozinha", name = "Feminine", steprules = steprules), "sozinho")
})

test_that("Adverb Reduction Rule", {
  expect_equal(rslp:::apply_rules("felizmente", name = "Adverb", steprules = steprules), "feliz")
})

test_that("Aumentative/Dimunutive Reduction Rules", {
  expect_equal(rslp:::apply_rules("cansad\u00edssimo", name = "Augmentative", steprules = steprules), "cansa")
  # expect_equal(rslp:::apply_rules("amabil\u00edssimo", name = "Augmentative", steprules = steprules), "ama")
  expect_equal(rslp:::apply_rules("fort\u00edssimo", name = "Augmentative", steprules = steprules), "fort")
  expect_equal(rslp:::apply_rules("chiqu\u00e9rrimo", name = "Augmentative", steprules = steprules), "chiqu")
  expect_equal(rslp:::apply_rules("pezinho", name = "Augmentative", steprules = steprules), "pe")
  expect_equal(rslp:::apply_rules("maluquinho", name = "Augmentative", steprules = steprules), "maluc")
  expect_equal(rslp:::apply_rules("amiguinho", name = "Augmentative", steprules = steprules), "amig")
  expect_equal(rslp:::apply_rules("cansadinho", name = "Augmentative", steprules = steprules), "cans")
  expect_equal(rslp:::apply_rules("carrinho", name = "Augmentative", steprules = steprules), "carr")
  expect_equal(rslp:::apply_rules("grandalh\u00e3o", name = "Augmentative", steprules = steprules), "grand")
  expect_equal(rslp:::apply_rules("dentu\u00e7a", name = "Augmentative", steprules = steprules), "dent")
  expect_equal(rslp:::apply_rules("mulhera\u00e7o", name = "Augmentative", steprules = steprules), "mulher")
  expect_equal(rslp:::apply_rules("cansad\u00e3o", name = "Augmentative", steprules = steprules), "cans")
  expect_equal(rslp:::apply_rules("corp\u00e1zio", name = "Augmentative", steprules = steprules), "corp")
  expect_equal(rslp:::apply_rules("pratarraz", name = "Augmentative", steprules = steprules), "prat")
  expect_equal(rslp:::apply_rules("bocarra", name = "Augmentative", steprules = steprules), "boc")
  expect_equal(rslp:::apply_rules("calorz\u00e3o", name = "Augmentative", steprules = steprules), "calor")
  expect_equal(rslp:::apply_rules("menin\u00e3o", name = "Augmentative", steprules = steprules), "menin")
})
