% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lanzante.R
\name{Lanzante}
\alias{Lanzante}
\title{Lanzante L-test}
\usage{
Lanzante(data, col, time, p = 0.05, merge = FALSE)
}
\arguments{
\item{data}{The dataframe to be used.}

\item{col}{The column we are measuring change on.}

\item{time}{The column containing time units (e.g. age of a subsample)}

\item{p}{The largest p-value you want to check regime shifts for. Defaults to p = 0.05.}

\item{merge}{Sets the result to be either a regime-shift only table (if FALSE), or an addition to the original table (if TRUE)}
}
\value{
If merge = FALSE (default), produces a 2-column table of time (the time value for each regime shift) and p (the p-value for each regime shift). If merge = TRUE, returns the original dataset with an extra p-value column, giving the p-value for each time unit - 0 for non-shift years.
}
\description{
performs the L-method for detection of regime shifts (Lanzante, 1996)
}
\examples{
Lanzante(lake_data, "DCA1", "Age")
Lanzante(lake_data, "DCA1", "Age", p=0.10, merge=TRUE)
}
