% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connections.R
\name{set_credentials}
\alias{set_credentials}
\alias{set_credentials,character,character,missing-method}
\alias{set_credentials,character,character,missing}
\alias{set_credentials,character,character,character-method}
\alias{set_credentials,character,character,character}
\title{Saves the credentials for the web services}
\usage{
set_credentials(user, pass, credential)

\S4method{set_credentials}{character,character,missing}(user, pass)

\S4method{set_credentials}{character,character,character}(user, pass, credential)
}
\arguments{
\item{user}{character argument. Defines the username of an api platform
to search or download images}

\item{pass}{character argument. Defines the password of an api platform
to search and download images}

\item{credential}{optional argument to specify the name of the platform.
Valid names are earthdata, scihub, scihubs5p, or ALL}
}
\value{
nothing. set the credentials in the package environment variable
}
\description{
Saves the credentials for the web services
}
\examples{
print_credentials()
set_credentials("example", "example")
print_credentials()
set_credentials("example", "example", "earthdata")
print_credentials()
}
