/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpPropFunc
extends Op1 {
    private Node uri;
    private PropFuncArg subjectArgs;
    private PropFuncArg objectArgs2;

    public OpPropFunc(Node uri, PropFuncArg args1, PropFuncArg args2, Op op) {
        super(op);
        this.uri = uri;
        this.subjectArgs = args1;
        this.objectArgs2 = args2;
    }

    public PropFuncArg getSubjectArgs() {
        return this.subjectArgs;
    }

    public PropFuncArg getObjectArgs() {
        return this.objectArgs2;
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Node getProperty() {
        return this.uri;
    }

    public Op copy(Op op) {
        return new OpPropFunc(this.uri, this.subjectArgs, this.objectArgs2, op);
    }

    public int hashCode() {
        return this.uri.hashCode() ^ this.getSubOp().hashCode();
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpPropFunc)) {
            return false;
        }
        OpPropFunc procFunc = (OpPropFunc)other;
        return this.getSubOp().equalTo(procFunc.getSubOp(), labelMap);
    }

    public String getName() {
        return "propfunc";
    }
}

