/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.lib.DatasetLib;
import java.io.InputStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotException;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangBase;
import org.openjena.riot.lang.LangNQuads;
import org.openjena.riot.lang.LangTriG;
import org.openjena.riot.lang.SinkQuadsToDataset;
import org.openjena.riot.lang.SinkTriplesToGraph;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiotLoader {
    public static DatasetGraph load(String filename) {
        return RiotLoader.load(filename, Lang.guess(filename, Lang.NQUADS));
    }

    public static DatasetGraph load(String filename, Lang lang) {
        DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
        RiotLoader.read(filename, dsg, lang, null);
        return dsg;
    }

    public static DatasetGraph load(String filename, Lang lang, String baseURI) {
        DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
        RiotLoader.read(filename, dsg, lang, baseURI);
        return dsg;
    }

    public static DatasetGraph datasetFromString(String string, Lang language, String baseURI) {
        DatasetGraph dsg = DatasetLib.createDatasetGraphMem();
        Sink<Quad> sink = RiotLoader.datasetSink(dsg);
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerString(string);
        if (language == Lang.NQUADS) {
            LangNQuads parser = RiotReader.createParserNQuads(tokenizer, sink);
            parser.parse();
            sink.flush();
            return dsg;
        }
        if (language == Lang.TRIG) {
            LangTriG parser = RiotReader.createParserTriG(tokenizer, baseURI, sink);
            parser.parse();
            sink.flush();
            return dsg;
        }
        return dsg;
    }

    public static void read(String filename, DatasetGraph dataset) {
        Lang lang = Lang.guess(filename);
        if (lang == null) {
            throw new RiotException("Can't guess language for " + filename);
        }
        InputStream input = IO.openFile(filename);
        RiotLoader.read(input, dataset, lang, filename);
    }

    public static void read(String filename, DatasetGraph dataset, Lang lang) {
        RiotLoader.read(filename, dataset, lang, filename);
    }

    public static void read(String filename, DatasetGraph dataset, Lang lang, String baseURI) {
        InputStream input = IO.openFile(filename);
        RiotLoader.read(input, dataset, lang, filename);
    }

    public static void read(InputStream input, DatasetGraph dataset, Lang language, String baseURI) {
        if (language.isQuads()) {
            Sink<Quad> sink = RiotLoader.datasetSink(dataset);
            RiotLoader.readQuads(input, language, baseURI, sink);
        } else {
            Sink<Triple> sink = RiotLoader.graphSink(dataset.getDefaultGraph());
            RiotLoader.readTriples(input, language, baseURI, sink);
        }
    }

    public static void readQuads(InputStream input, Lang language, String baseURI, Sink<Quad> sink) {
        if (language == Lang.NQUADS) {
            LangNQuads parser = RiotReader.createParserNQuads(input, sink);
            parser.parse();
            sink.flush();
            return;
        }
        if (language == Lang.TRIG) {
            LangTriG parser = RiotReader.createParserTriG(input, baseURI, sink);
            parser.parse();
            sink.flush();
            return;
        }
        throw new RiotException("Language not supported for quads: " + (Object)((Object)language));
    }

    public static void readTriples(InputStream input, Lang language, String baseURI, Sink<Triple> sink) {
        LangBase parser;
        switch (language) {
            case NTRIPLES: {
                parser = RiotReader.createParserNTriples(input, sink);
                break;
            }
            case TURTLE: {
                parser = RiotReader.createParserTurtle(input, baseURI, sink);
                break;
            }
            default: {
                throw new RiotException("Language not supported for triples: " + (Object)((Object)language));
            }
        }
        parser.parse();
        sink.flush();
    }

    public static Sink<Triple> graphSink(Graph graph) {
        return new SinkTriplesToGraph(graph);
    }

    public static Sink<Quad> datasetSink(DatasetGraph dataset) {
        return new SinkQuadsToDataset(dataset);
    }
}

