/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.IdentityHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class E_BNode
extends ExprFunctionN {
    private static final String symbol = "bnode";
    private static final Symbol keyMap = Symbol.create("arq:internal:bNodeMappings");

    public E_BNode() {
        this((Expr)null);
    }

    public E_BNode(Expr expr) {
        super(symbol, expr);
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        LabelToNodeMap mapper;
        Expr expr = null;
        if (this.args.size() == 1) {
            expr = this.getArg(1);
        }
        if (expr == null) {
            return NodeValue.makeNode(Node.createAnon());
        }
        NodeValue x = expr.eval(binding, env);
        if (!x.isString()) {
            throw new ExprEvalException("Not a string: " + x);
        }
        Integer key = System.identityHashCode(binding);
        IdentityHashMap<Binding, LabelToNodeMap> mapping = (IdentityHashMap<Binding, LabelToNodeMap>)env.getContext().get(keyMap);
        if (mapping == null) {
            mapping = new IdentityHashMap<Binding, LabelToNodeMap>();
            env.getContext().set(keyMap, mapping);
        }
        if ((mapper = (LabelToNodeMap)mapping.get(binding)) == null) {
            mapper = LabelToNodeMap.createBNodeMap();
            mapping.put(binding, mapper);
        }
        Node bnode2 = mapper.asNode(x.getString());
        return NodeValue.makeNode(bnode2);
    }

    @Override
    protected NodeValue eval(List<NodeValue> args) {
        throw new ARQInternalErrorException();
    }

    @Override
    protected Expr copy(ExprList newArgs) {
        if (newArgs.size() == 0) {
            return new E_BNode();
        }
        return new E_BNode(newArgs.get(0));
    }
}

