/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.OntResourceImpl;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRangeImpl
extends OntResourceImpl
implements DataRange {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new DataRangeImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to DataRange");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, DataRange.class);
        }
    };

    public DataRangeImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setOneOf(RDFList en) {
        this.setPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", en);
    }

    @Override
    public void addOneOf(Literal lit) {
        this.addListPropertyValue(this.getProfile().ONE_OF(), "ONE_OF", lit);
    }

    @Override
    public void addOneOf(Iterator<Literal> literals) {
        while (literals.hasNext()) {
            this.addOneOf(literals.next());
        }
    }

    @Override
    public RDFList getOneOf() {
        return this.objectAs(this.getProfile().ONE_OF(), "ONE_OF", RDFList.class);
    }

    @Override
    public ExtendedIterator<Literal> listOneOf() {
        return this.getOneOf().iterator().mapWith(new OntResourceImpl.AsMapper<Literal>(Literal.class));
    }

    @Override
    public boolean hasOneOf(Literal lit) {
        return this.getOneOf().contains(lit);
    }

    @Override
    public void removeOneOf(Literal lit) {
        this.setOneOf(this.getOneOf().remove(lit));
    }
}

