% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_ex.R
\name{wrap}
\alias{wrap}
\title{Wrap a data frame for later execution.}
\usage{
wrap(d, ..., table_name = NULL, env = parent.frame())
}
\arguments{
\item{d}{data.frame}

\item{...}{not used, force later argument to be referred by name}

\item{table_name}{character, name of table}

\item{env}{environment to work in.}
}
\value{
a table description, with data attached
}
\description{
Create a table description that includes the actual data.  Prevents wastefull table copies in
immediate pipelines.  Used with \code{ex()}.
}
\examples{

if(requireNamespace('rqdatatable')) {
 d <- data.frame(x = 1:3, y = 4:6)
 d \%.>\%
   wrap(.) \%.>\%
   extend(., z := x + y) \%.>\%
   ex(.)
}

}
