% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile.R
\name{quantile_cols}
\alias{quantile_cols}
\title{Compute quantiles of specified columns
(without interpolation, needs a database with window functions).}
\usage{
quantile_cols(db, incoming_table_name, ..., probs = seq(0, 1, 0.25),
  probs_name = "quantile_probability", cols = rq_colnames(db,
  incoming_table_name))
}
\arguments{
\item{db}{database connection}

\item{incoming_table_name}{name of table to compute quantiles of}

\item{...}{force later arguments to bind by name}

\item{probs}{numeric, probabilities to compute quantiles of}

\item{probs_name}{character name for probability column}

\item{cols}{character, columns to compute quantiles of}
}
\value{
data.frame of quantiles
}
\description{
Compute quantiles of specified columns
(without interpolation, needs a database with window functions).
}
\seealso{
\code{\link{quantile_node}}, \code{\link{rsummary}}
}
