% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_ops.R
\name{getDBOption}
\alias{getDBOption}
\title{Set a database connection option.}
\usage{
getDBOption(db, optname, default, connection_options = list())
}
\arguments{
\item{db}{database connection handle.}

\item{optname}{character, single option name.}

\item{default}{what to return if not set.}

\item{connection_options}{name list of per connection options.}
}
\value{
option value
}
\description{
Set a database connection option.
}
\examples{

if(requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(getDBOption(my_db, "use_DBI_dbExecute"))
  DBI::dbDisconnect(my_db)
}

}
