% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_clutch.R
\name{doubleapply}
\alias{doubleapply}
\alias{\%>>\%}
\title{Double apply pipe to local data frame.}
\usage{
d \%>>\% ops
}
\arguments{
\item{d}{data.frame.}

\item{ops}{free-form op tree.}
}
\value{
\code{rquery::rquery_apply_to_data_frame(d \%.>\% ops)}
}
\description{
Defined as roughly : \code{rquery::rquery_apply_to_data_frame(d \%.>\% ops)}.
Useful for systems like \code{rquery} where first appearance of an object
captures a description and second appearance applies the operation.
}
\details{
Note: to make this usefull one must parenthesize the pipeline that are
piping into to.  This is to work around left to right associativity.
Please see the example for how this is done.
}
\examples{

# WARNING: example tries to change rquery.rquery_db_executor option to RSQLite and back.
if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  old_o <- options(list("rquery.rquery_db_executor" = list(db = my_db)))

  data.frame(AUC = c(0.6, 0.45), R2 = c(0.2, 0.01)) \%>>\% (
    extend_se(., c("v" \%:=\% "AUC + R2", "x" \%:=\% "pmax(AUC,v)")) \%.>\%
    select_rows_nse(., x > 0.5) ) \%.>\%
    print(.)

  options(old_o)
  DBI::dbDisconnect(my_db)
}




}
