% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_diagram.R
\name{op_diagram}
\alias{op_diagram}
\title{Build a diagram of a optree pipeline.}
\usage{
op_diagram(optree, ..., merge_tables = FALSE)
}
\arguments{
\item{optree}{operation tree pipeline.}

\item{...}{force other argument to be by name.}

\item{merge_tables}{logical if TRUE merge all same table references into one node.}
}
\value{
character DiagrammeR::grViz() ready text.
}
\description{
Build a diagram of a optree pipeline.
}
\examples{

d <- table_source('d',
             columns = qc(AUC, R2))
optree <- d \%.>\%
  extend_nse(., v := ifelse(AUC>0.5, R2, 1.0)) \%.>\%
  quantile_node(.) \%.>\%
  natural_join(., d, jointype = "LEFT", by = "AUC") \%.>\%
  orderby(., "AUC")

cat(format(optree))

cat(op_diagram(optree))

if(requireNamespace("DiagrammeR", quietly = TRUE)) {
  optree \%.>\%
    op_diagram(., merge_tables = TRUE) \%.>\%
    DiagrammeR::grViz(.) \%.>\%
    print(.)
}

}
