% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi_ops.R
\name{dbi_connection_preferences}
\alias{dbi_connection_preferences}
\title{Get reasonable stored options for a DB connection.}
\usage{
dbi_connection_preferences(db)
}
\arguments{
\item{db}{DBI database connection}
}
\value{
named list of options
}
\description{
These settings are from what was known in March 2018 about
RSQLite, Sparklyr, RPostgreSQL, and RPostgres.  This is the
full set of dbi options for rquery.
}
\examples{

if(requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  print(dbi_connection_name(my_db))
  print(dbi_connection_preferences(my_db))
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{dbi_connection_tests}}
}
