% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_plum.R
\name{draw.pbmeasured}
\alias{draw.pbmeasured}
\title{Plot the 210Pb data}
\usage{
draw.pbmeasured(
  set = get("info"),
  rotate.axes = FALSE,
  rev.d = FALSE,
  rev.age = FALSE,
  BCAD = set$BCAD,
  pb.lim = c(),
  age.lim = c(),
  d.lim = c(),
  d.lab = c(),
  pb.lab = c(),
  pbmeasured.col = "blue",
  pb.log = FALSE,
  supp.col = "purple",
  newplot = TRUE,
  on.agescale = FALSE
)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{rotate.axes}{The default of plotting age on the horizontal axis and event probability on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{rev.d}{The direction of the depth axis can be reversed from the default (\code{rev.d=TRUE}).}

\item{rev.age}{The direction of the calendar age axis can be reversed from the default (\code{rev.age=TRUE})}

\item{BCAD}{The calendar scale of graphs and age output-files is in cal BP (calendar or calibrated years before the present, where the present is AD 1950) by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{pb.lim}{Minimum and maximum of the 210Pb axis ranges, calculated automatically by default (\code{pb.lim=c()}).}

\item{age.lim}{Minimum and maximum of the age ranges to be used to plot 210Pb values. Calculated automatically by default (\code{age.lim=c()}).}

\item{d.lim}{Minimum and maximum depths to plot; calculated automatically by default (\code{d.lim=c()}).}

\item{d.lab}{The labels for the depth axis. Default \code{d.lab="Depth (cm)"}.}

\item{pb.lab}{The label for the 210Pb axis (default \code{pb.lab="210Pb (Bq/kg)"} or \code{"210Pb (dpm/g)"}).}

\item{pbmeasured.col}{The label for the measured 210Pb data. \code{pbmeasured.col="blue"}.}

\item{pb.log}{Use a log scale for the 210Pb-axis (default \code{pb.log=FALSE}).}

\item{supp.col}{Colour of the supported 210Pb data. Defaults to red: \code{supp.col="red"}.}

\item{newplot}{make new plot (default TRUE)}

\item{on.agescale}{Plot the Pb-210 on the cal BP scale. Defaults to FALSE.}
}
\value{
A plot of the measured 210Pb values
}
\description{
Produce a plot of the 210Pb data and their depths
}
\details{
This function is generally called internally to produce the age-depth graph.
It can be used to produce custom-built graphs.
}
\author{
Maarten Blaauw, J. Andres Christen, Marco Aquino-Lopez
}
