% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/msa.R
\name{msa}
\alias{msa}
\title{MSA Objects}
\usage{
msa(seqs, names = NULL, alphabet = "ACGT", is.ordered = TRUE,
  offset = NULL, pointer.only = FALSE)
}
\arguments{
\item{seqs}{a character vector containing sequences, one per sample}

\item{names}{a character vector identifying the sample name for each
sequence.  If \code{NULL}, use "seq1", "seq2", ...}

\item{alphabet}{a character string containing valid non-missing character
states}

\item{is.ordered}{a logical indicating whether the alignment columns
are stored in order.  If NULL, assume columns are ordered.}

\item{offset}{an integer giving the offset of coordinates for the
reference sequence from the beginning of the chromosome.  The reference
sequence is assumed to be the first sequence.  Not used
if is.ordered==FALSE.}

\item{pointer.only}{a boolean indicating whether returned alignment object
should be stored by reference (see Details)}
}
\description{
Creates a new MSA object given sequences.
}
\details{
Make a new multiple sequence alignment (MSA) object given a vector of
character strings.  They can be optionally annotated with sample names.

Each character string in seqs must be the same length, and number of
elements in names (if provided) must match the number of elements in
seqs.

Alphabet generally does not have to be specified if working with
DNA alignments.

About storing objects as pointers:
If \code{pointer.only==FALSE}, the MSA object will be stored in R and can be
viewed and modified by base R code as well as RPHAST functions.
Setting \code{pointer.only=TRUE} will cause the object to be stored by
reference, as an external pointer to an object created by C code.  This
may be necessary to improve performance, but the object can then only
be viewed/manipulated via RPHAST functions.  Furthermore, if an object
is stored as a pointer, then its value is liable to be changed when
passed as an argument to a function.  All RPHAST functions which change
the value of an external pointer make a note of this in the help pages
for that function.  For example, extract.feature.msa will alter an
alignment if it is passed in as an external pointer (the argument will
be changed into the return value).  If this is undesireable, the copy.msa
function can be used: extract.feature.msa(copy.msa(align)) will preserve
the original alignment.  Simple copying, ie, \code{align2->align1} of
objects stored as pointer will not behave like normal R objects: both objects
will point to the same C structure, and both will be changed if either one
is altered.  Instead \code{align2 <- copy.msa(align1)} should be used.
}
\examples{
# Here is an MSA object stored in the default mode
m1 <- msa(seqs=c("ACGTAT", "AGGTAA", "AGGTAG"),
          names=c("human", "mouse", "rat"))
m2 <- m1
# NOTE seqs would not be directly accessible if stored by reference
m2$seqs[3] <- "AAAAAA"
print(m1)
print(m1, print.seq=TRUE)
print(m2, print.seq=TRUE)
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\keyword{msa}

