% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feat.R
\name{overlap.feat}
\alias{overlap.feat}
\title{Feature overlap}
\usage{
overlap.feat(x, filter, numbase = 1, min.percent = NULL,
  overlapping = TRUE, get.fragments = FALSE, pointer.only = FALSE)
}
\arguments{
\item{x}{An object of type \code{feat} containing features to select}

\item{filter}{An object of type \code{feat} which determines which elements of x to select}

\item{numbase}{The number of bases of overlap between x and filter required to choose
a record.  Use NULL to ignore (but then min.percent must be defined)}

\item{min.percent}{The minimum percent that a record must overlap with the combined records in filter
in order to be chosen}

\item{overlapping}{If \code{FALSE}, choose records with less than numbase overlapping bases,
and less than min.percent fraction overlap if min.percent is not \code{NULL}}

\item{get.fragments}{If \code{FALSE}, entire records are selected from x based on whether
they meet selection criteria.   
If \code{TRUE}, return only the fragments of x that overlap
with filter.  In this case, the same fragments may be output multiple times, if they are
selected by multiple entries in filter.  numbase and min.percent apply in either case.
When this option is used, the return value is a list with two gffs.  The first (named frags)
contains the overlapping fragments, and the second (filter.frags) contain the fragments
from filter which selected the overlapping fragments.}

\item{pointer.only}{If \code{TRUE}, the return object will only be a
pointer to an object stored in C (useful for very large features; advanced use only).}
}
\value{
an object of type \code{feat} containing the selected entries from x (unless
get.fragments==TRUE, then it returns a list with two \code{feat} objects; see
get.fragments).
}
\description{
Creates a features object containing all the features from one set which overlap
features from another.
}
\note{
If either x or filter are feature objects stored as a pointer to C memory,
then this function may reorder the elements in these objects, but leave them
otherwise unchanged.
}
\examples{
feat1 <- feat(seqname=c(rep("chr1", 3), rep("chr2", 2)),
              start=c(1, 5, 100, 10, 20),
              end=c(7, 10, 105, 15, 30))
feat2 <- feat(seqname=c("chr1","chr2"),
              start=c(1,1),
              end=c(5,10))

overlap.feat(feat1, feat1)
overlap.feat(feat1, feat2, min.percent=0.25)
overlap.feat(feat1, feat2, min.percent=0.25, overlapping=FALSE)
overlap.feat(feat1, feat2, get.fragments=TRUE)
overlap.feat(feat1, feat2, get.fragments=TRUE)
rm(feat1, feat2)
}
\author{
Melissa J. Hubisz
}
\keyword{features}

