\name{ncol.feat}
\alias{ncol.feat}
\title{Number of Columns in Features}
\usage{
  \method{ncol}{feat} (x)
}
\arguments{
  \item{x}{An object of type \code{feat}}
}
\value{
  An integer containing the number of columns in the
  features object
}
\description{
  Get the number of columns in a features object
}
\note{
  If the features object is stored as a pointer in C, the
  number of columns is always 9.
}
\examples{
seq <- rep("hg18.chr6", 10)
src <- rep("fake_example", 10)
feature <- rep("CDS", 10)
start <- seq(1, 100, by=10)
end <- seq(10, 100, by=10)
f <- feat(seq, src, feature, start, end)
ncol.feat(f)
ncol.feat(as.pointer.feat(f))
}
\author{
  Melissa J. Hubisz
}
\keyword{features}

