% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpg.R
\name{list_tables}
\alias{describe_table}
\alias{list_databases}
\alias{list_schema}
\alias{list_tables}
\title{PostgreSQL database information}
\usage{
list_tables(only.names = TRUE)

describe_table(tablename, schemaname = NULL)

list_schema(only.names = TRUE)

list_databases(only.names = TRUE)
}
\arguments{
\item{only.names}{if true, just list the table names}

\item{tablename}{the name of a PostgreSQL table}

\item{schemaname}{if not null, look only in this schema}
}
\value{
\code{list_tables}: a vector of table names or a data frame

\code{describe_table}: a data frame with column information
}
\description{
Get information about tables in a database
}
\examples{
\dontrun{
createdb("rpgtesting")
connect("rpgtesting")
begin()
 
# write data frame contents
data(mtcars)
write_table(mtcars)
 
# get some information
list_tables()
describe_table("mtcars")
list_schema()
list_databases()

#cleanup
rollback()
disconnect()
dropdb("rpgtesting")}

}
\author{
Timothy H. Keitt
}
\seealso{
\code{\link{psql}}
}

