% Generated by roxygen2 (4.0.1): do not edit by hand
\name{trace_conn}
\alias{dump_conn_trace}
\alias{trace_conn}
\alias{trace_filename}
\alias{untrace_conn}
\title{PostgeSQL connection tracing}
\usage{
trace_conn(filename = "", append = FALSE)

untrace_conn(remove = FALSE)

trace_filename()

dump_conn_trace(warn = FALSE, ...)
}
\arguments{
\item{filename}{where to send the tracing}

\item{append}{if true, append to existing file}

\item{remove}{if true, unlink the tracing file}

\item{warn}{if true, \code{\link{readLines}} will issue warnings}

\item{...}{passed to \code{\link{readLines}}}
}
\value{
\code{trace_filename}: the name of the file containing
trace information.
}
\description{
Functions to manage connection tracing
}
\details{
PostgeSQL tracing lets you observe all information
passing between \code{rpg} and the database server.

\code{trace_conn} begins tracing and \code{untrace_conn}
stops tracing.

\code{dump_conn_trace} invokes \code{\link{readLines}} on
the trace file.
}
\examples{
\dontrun{
system("createdb rpgtesting")
connect("rpgtesting")
trace_conn()
list_tables()
dump_conn_trace(n = 40)
untrace_conn(remove = TRUE)
disconnect()
system("dropdb rpgtesting")}
}
\author{
Timothy H. Keitt
}

