% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{build_convert_edits}
\alias{build_convert_edits}
\title{Build a collection of conversion edits}
\usage{
build_convert_edits(format, tags, unmatched = FALSE)
}
\arguments{
\item{format}{(\code{character[1]}) A regular expression, optionally containing named capture groups for \code{type}
and \code{description}, which will be used for restructuring the tag as a
\code{roxytypes}-equivalent tag.}

\item{tags}{(\code{list(roxy_tag)}) A collection of \code{\link[roxygen2:roxy_tag]{roxygen2::roxy_tag()}} objects to edit. Can include tags
which have no plausible conversion, which will be filtered before returning
edits.}

\item{unmatched}{(\code{logical[1]}) Whether to make edits to existing tags which can not be matched with the
provided format. If \code{TRUE}, the existing description is migrated verbatim
to the new tag, without a type provided. The new syntax will produce
warnings when running \code{\link[roxygen2:roxygenize]{roxygen2::roxygenize()}}, which can be useful tool
for pinpointing tags that need manual fine-tuning for conversion.}
}
\value{
(\code{data.frame}) A collection of possible tag edits as produced by \code{\link[=tag_edit]{tag_edit()}}.
}
\description{
Build a collection of conversion edits
}
\seealso{
Other convert: 
\code{\link{convert_match_format}()},
\code{\link{convert_tag}()},
\code{\link{make_convert_edits}()},
\code{\link{tag_edit}()}
}
\concept{convert}
\keyword{internal}
