% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_re.R
\name{build_format_regex}
\alias{build_format_regex}
\alias{re_backticked}
\alias{re_any}
\alias{escape_non_glue_re}
\title{Build format regular expression}
\usage{
build_format_regex(
  format,
  format_re,
  ...,
  type = re_backticked(),
  description = re_any()
)

re_backticked()

re_any()

escape_non_glue_re(x)
}
\arguments{
\item{format}{(\code{character[1]}) A \code{glue}-style format string. Expanded whisker values are used as a
shorthand for capture groups, where ellipsis arguments can be provided
for additional capture group patterns.}

\item{format_re}{(\code{character[1]}) Alternatively, provide a standard regular expression directly.}

\item{...}{Additional arguments provide keyworded capture groups for \code{format}}

\item{type}{(\code{character[1]}) A regular expression to use to match a type signature. By default, matches
within backticks.}

\item{description}{(\code{character[1]}) A regular expression to use to match a parameter description. By default,
matches any string.}

\item{x}{(\code{character[1]}) A string to escape.}
}
\value{
(\verb{character[1]:}) A regular expression string, built from component sub-expressions.
}
\description{
Allow \code{glue}-style formatting using keyworded regular expressions. The
original \code{glue} string (anything that isn't expanded by \code{glue}) is treated as
a string literal, whereas the contents of populated values can be regular
expressions, allowing for a more user-friendly way to construct complicated
regular expressions.
}
\details{
To bypass glue entirely and use a standard regular expression, use
\code{format_re}.

The provided regular expression must match all characters from the start of a
string to the end. The string also matches using "dot all" syntax, meaning
that the \code{.} expression will also match newline characters.
}
\section{Functions}{
\itemize{
\item \code{re_backticked()}: Match within backticks

\item \code{re_any()}: Match any

\item \code{escape_non_glue_re()}: Escape all regular expression special characters

In addition, avoid escaping \code{{}}'s that appear to be used as \code{glue} keywords.
Handles only simple cases, and does not handle recusive curly nesting.

}}
\examples{
re <- roxytypes:::build_format_regex(
  "{as}{any}{bs}",
  as = "a+",
  bs = "b+",
  any = ".*?"
)

roxytypes:::regex_capture(re, "aaaa\n\nbb", perl = TRUE)

text <- "@param (`test(\")\")`)"

pattern <- sprintf("`\%s`", re_backticked())

m <- regexec(pattern, text, perl = TRUE)
regmatches(text, m)[[1]]
# [1] "`test(\")\")`"

# curlies escaped, as this does not appear to be a glue-style usage
roxytypes:::escape_non_glue_re(".{1,3}")

# curlies not escaped, as this is a glue-style usage
roxytypes:::escape_non_glue_re("this is a {test}")

}
