test_that("@example loads from specified files", {
  out <- roc_proc_text(rd_roclet(), "
    #' @name a
    #' @title a
    #'
    #' @example Rd-example-1.R
    #' @example Rd-example-2.R
    NULL")[[1]]

  examples <- out$get_value("examples")
  expect_match(examples, fixed("example <- 'example1'"), all = FALSE)
  expect_match(examples, fixed("example <- 'example2'"), all = FALSE)
})

test_that("@example captures examples (#470)", {
  out <- roc_proc_text(rd_roclet(), "
    #' @name a
    #' @title a
    #' @examples
    #' TRUE
    #' @examples
    #' FALSE
    NULL")[[1]]

  examples <- out$get_value("examples")
  expect_equal(examples, rd(c("TRUE", "FALSE")))
})

test_that("@examples and @example interleave", {
  out <- roc_proc_text(rd_roclet(), "
    #' @name a
    #' @title a
    #' @example Rd-example-1.R
    #' @examples a <- 2
    #' @example Rd-example-2.R
    NULL")[[1]]

  verify_output(test_path("test-rd-examples-interleave.txt"), {
    out$get_section("examples")
  })
})

test_that("@example does not introduce extra empty lines", {
  out <- roc_proc_text(rd_roclet(), "
    #' @name a
    #' @title a
    #' @example Rd-example-3.R
    NULL")[[1]]

  expect_length(out$get_value("examples"), 2L)
})

test_that("@example gives warning if used instead of @examples", {
  expect_warning(
    out <- roc_proc_text(rd_roclet(), "
      #' @name a
      #' @title a
      #' @example
      #' a <- 1
      #' a + b
      NULL")[[1]],
    "spans multiple lines"
  )

  expect_null(out$get_value("examples"))
})

test_that("warns if path doesn't exist", {
  expect_warning(
    roc_proc_text(rd_roclet(), "
      #' @name a
      #' @title a
      #' @example this-path-doesnt-exist.R
      NULL
    "),
    "doesn't exist"
  )
})

test_that("% in @examples escaped before matching braces test (#213)", {
  out <- roc_proc_text(rd_roclet(), "
    #' @name a
    #' @title a
    #' @examples
    #' {a %% b}
    NULL")[[1]]

  expect_equal(out$get_value("examples"), rd("{a \\%\\% b}"))
})

# escapes ------------------------------------------------------------------

test_that("% and \\ in @example escaped", {
  expect_equal(escape_examples("x %*% y # \\x"), rd("x \\%*\\% y # \\\\x"))
})

test_that("escapes within strings are not double escaped", {
  expect_equal(escape_examples("'34.00\\'"), rd("'34.00\\'"))
})

test_that("\\dontrun etc. is not escaped #1", {
  expect_equal(escape_examples("\\dontrun{x <- 1}"), rd("\\dontrun{x <- 1}"))

  expect_equal(
    escape_examples("\\dontrun{ \\{ x <- 1 \\} }"),
    rd("\\dontrun{ \\{ x <- 1 \\} }")
  )
})

test_that("\\dontrun etc. is not escaped #2", {
  out <- roc_proc_text(rd_roclet(), "
    #' @name a
    #' @title a
    #' @examples
    #' \\dontshow{ \\{ }
    #' # Hidden!
    #' \\dontshow{ \\} }
    NULL")[[1]]

  verify_output(test_path("test-rd-examples-dotrun-escape.txt"), {
    out$get_section("examples")
  })
})
