% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{download_osv}
\alias{download_osv}
\title{Download helper for OSV data}
\usage{
download_osv(ecosystem, id = NULL, refresh = FALSE)
}
\arguments{
\item{ecosystem}{Character value of ecosystem, any listed on OSV database.}

\item{id}{Vulnerability ID, default set to NULL to download all for provided ecosystem.}

\item{refresh}{Force refresh of the cache to grab latest details from OSV databases.}
}
\value{
A list containing the cache and download locations for the vulnerability files.
}
\description{
Helper function to assist in downloading vulnerabilities information from OSV database.
}
\details{
Any ecosystems listed \href{https://osv-vulnerabilities.storage.googleapis.com/ecosystems.txt}{here} can be downloaded.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

osv_dl <- download_osv('CRAN')

# Clean up
try(unlink(osv_dl$osv_cache, recursive = TRUE))
try(unlink(osv_dl$dl_dir, recursive = TRUE))
\dontshow{\}) # examplesIf}
}
