\name{angle}
\alias{angle}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Standardised last principal angle
}
\description{
Standardised last principal angle between the subspaces generated by the columns of \code{A} and \code{B}.
}
\usage{
angle(A, B)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{A}{Numeric matrix of size \eqn{p} by \eqn{k}.
}
  \item{B}{Numeric matrix of size \eqn{q} by \eqn{l}.
}
}
\details{
We compute the last principal angle between the subspaces generated by the columns of \code{A} and \code{B} using
the algorithm in Bjorck and Golub (1973). This angle takes values between 0 and \eqn{\pi/2}. We divide it by  \eqn{\pi/2} to make it take values between 0 and 1, where 0 indicates that the subspaces are close.
}

\value{
Standardised last principal angle between \code{A} and \code{B}.
}
\references{
Bjorck, A. and Golub, G. H. (1973), ``Numerical Methods for Computing Angles Between Linear Subspaces," \emph{Mathematics of Computation}, 27, 579--594.
}
\author{
Tom Reynkens
}



\examples{
tmp <- dataGen(m=1)

P <- eigen(tmp$R)$vectors[,1:2]
PP <- rospca(tmp$data[[1]], k=2)$loadings

angle(P, PP)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ algebra }
