% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_grid_identical.R
\name{build_grid_identical}
\alias{build_grid_identical}
\title{Build a regular grid}
\usage{
build_grid_identical(coords, npts, pad = 0, ...)
}
\arguments{
\item{coords}{A matrix or data frame of coordinates as columns}

\item{npts}{The approximate total number of points of the output grid}

\item{pad}{Padding on each dimension (a positive number makes a grid
that is larger than the ranges of the coordinates).}

\item{...}{other arguments are silently ignored}
}
\value{
The coordinates of a grid of points as a data frame with
        approximately \code{npts} rows and \code{ncol(coords)} columns. Names
        are transfered from the \code{coords} data frame.
}
\description{
Create a regular grid with the same number of points on each
             dimension.
}
\details{
This function creates a grid that covers a set of points. The 
         number of points of the output grid is the same on all dimensions. 
         This is probably the only useful option for 1D moving-window 
         computations.
}
\seealso{
Other grid.building.functions: \code{\link{build_grid_ahull_crop}},
  \code{\link{build_grid_ahull_fill}},
  \code{\link{build_grid_squaretile}}
}

