% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocker-package.R
\name{rocker-README}
\alias{rocker-README}
\title{README}
\description{
How-to and examples
}
\details{
Please read me.
}
\section{Installation}{
Installation of current released version from CRAN

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("rocker")
}\if{html}{\out{</div>}}

Installation of current development version from GitHub

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("devtools")
devtools::install_github("nikolaus77/rocker")
}\if{html}{\out{</div>}}
}

\section{New \emph{rocker} class object}{
Create new \emph{rocker} database handling object

Option 1

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

Option 2

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::rocker$new() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\strong{Terminal output}

Controlling terminal output

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB(verbose = TRUE) # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupPostgreSQL()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$verbose <- FALSE # Terminal output off
db$setupPostgreSQL()
db$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$verbose <- TRUE # Terminal output on (default)
db$setupPostgreSQL()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}

Structure of terminal output

\if{html}{\out{<div class="sourceCode">}}\preformatted{Dctr | Driver load RSQLite
D                          = Driver     (D = loaded,    d = not set)
 c                         = Connection (C = opened,    c = closed)
  t                        = Transation (T = active,    t = no tranastion)
   r                       = Result     (R = available, r = no result)
       Driver load RSQLite = Message text
}\if{html}{\out{</div>}}

\strong{Optional object ID}

Optionally, rocker object can be labeled with an ID. This can be helpful
in case terminal output of multiple rocker objects need to be
distinguished.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db1 <- rocker::newDB(id = "myDB 1") # New database handling object with ID
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## myDB 1 | dctr | New object id myDB 1
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db2 <- rocker::newDB(id = "myDB 2") # New database handling object with ID
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## myDB 2 | dctr | New object id myDB 2
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db1$setupPostgreSQL()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## myDB 1 | Dctr | Driver load RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db2$setupMariaDB()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## myDB 2 | Dctr | Driver load RMariaDB
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db1$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## myDB 1 | dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db2$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## myDB 2 | dctr | Driver unload RMariaDB
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db1$id <- NULL # Remove ID
db1$setupSQLite()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db1$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db1$id <- "newID 1" # Add new ID
db1$setupSQLite()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## newID 1 | Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db1$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## newID 1 | dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}

\strong{Object properties}

Object properties are stored in the info field and can be displayed by
print function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupPostgreSQL()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$info
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $package
## [1] "RPostgres"
## 
## $host
## [1] "127.0.0.1"
## 
## $port
## [1] "5432"
## 
## $dbname
## [1] "mydb"
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## object          
##   id            null
##   verbose       true
##   validateQuery null
## database        
##   package       RPostgres
##   host          127.0.0.1
##   port          5432
##   dbname        mydb
## status          
##   driver        true
##   connection    false
##   transaction   false
##   result        false
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$print()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## object          
##   id            null
##   verbose       true
##   validateQuery null
## database        
##   package       RPostgres
##   host          127.0.0.1
##   port          5432
##   dbname        mydb
## status          
##   driver        true
##   connection    false
##   transaction   false
##   result        false
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{print(db)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## object          
##   id            null
##   verbose       true
##   validateQuery null
## database        
##   package       RPostgres
##   host          127.0.0.1
##   port          5432
##   dbname        mydb
## status          
##   driver        true
##   connection    false
##   transaction   false
##   result        false
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}

\strong{Connection validation – Is the earlier opened database connection
still open?}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupSQLite()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$print()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## object          
##   id            null
##   verbose       true
##   validateQuery null
## database        
##   package       RSQLite
##   dbname        :memory:
## status          
##   driver        true
##   connection    false
##   transaction   false
##   result        false
}\if{html}{\out{</div>}}

During connection setup, a validateQuery is looked up automatically.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$print()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## object          
##   id            null
##   verbose       true
##   validateQuery SELECT 1
## database        
##   package       RSQLite
##   dbname        :memory:
## status          
##   driver        true
##   connection    true
##   transaction   false
##   result        false
}\if{html}{\out{</div>}}

Discovered validateQuery

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$validateQuery
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] "SELECT 1"
}\if{html}{\out{</div>}}

Validate connection

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$validateCon()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Connection valid true

## [1] TRUE
}\if{html}{\out{</div>}}

If required, validateQuery can be defined manually.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$validateQuery <- "SELECT 2"
db$validateCon()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Connection valid true

## [1] TRUE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$print()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## object          
##   id            null
##   verbose       true
##   validateQuery SELECT 2
## database        
##   package       RSQLite
##   dbname        :memory:
## status          
##   driver        true
##   connection    true
##   transaction   false
##   result        false
}\if{html}{\out{</div>}}

Clean up

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$disconnect()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$validateCon()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Connection valid false

## [1] FALSE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}
}

\section{Additional packages and database types}{
The listed packages are required for some functions of \emph{rocker}.
\subsection{\emph{RSQLite} package}{

\href{https://github.com/r-dbi/RSQLite}{\emph{RSQLite}} package for handling of
SQLite database connections. It is required for the setupSQLite()
function of \emph{rocker} class.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("RSQLite")
}\if{html}{\out{</div>}}

\strong{Setup database}

Option 1

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupSQLite( # Setup SQLite database
  dbname = ":memory:"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver() # Reset database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}

Option 2

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupDriver( # Setup SQLite database
  drv = RSQLite::SQLite(),
  dbname = ":memory:"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver() # Reset database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}
}

\subsection{\emph{RPostgres} package}{

\href{https://github.com/r-dbi/RPostgres}{\emph{RPostgres}} package for handling
of PostgreSQL database connections. It is required for the
setupPostgreSQL() function of \emph{rocker} class.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("RPostgres")
}\if{html}{\out{</div>}}

\strong{Setup database}

Option 1

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
#> dctr | New object
db$setupPostgreSQL( # Setup PostgreSQL database
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password"
)
#> Dctr | Driver load RPostgres
db$unloadDriver() # Reset database handling object
#> dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}

Option 2

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
#> dctr | New object
db$setupDriver( # Setup PostgreSQL database
  drv = RPostgres::Postgres(),
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password"
)
#> Dctr | Driver load RPostgres
db$unloadDriver() # Reset database handling object
#> dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}
}

\subsection{\emph{RMariaDB} package}{

\href{https://github.com/r-dbi/RMariaDB}{\emph{RMariaDB}} package for handling of
MariaDB and MySQL database connections. It is required for the
setupMariaDB() function of \emph{rocker} class.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("RMariaDB")
}\if{html}{\out{</div>}}

\strong{Setup database}

Option 1

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
#> dctr | New object
db$setupMariaDB( # Setup MariaDB database
  host = "127.0.0.1", port = "3306", dbname = "mydb",
  user = "root", password = "password"
)
#> Dctr | Driver load RMariaDB
db$unloadDriver() # Reset database handling object
#> dctr | Driver unload RMariaDB
}\if{html}{\out{</div>}}

Option 2

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
#> dctr | New object
db$setupDriver( # Setup MariaDB database
  drv = RMariaDB::MariaDB(),
  host = "127.0.0.1", port = "3306", dbname = "mydb",
  user = "root", password = "password"
)
#> Dctr | Driver load RMariaDB
db$unloadDriver() # Reset database handling object
#> dctr | Driver unload RMariaDB
}\if{html}{\out{</div>}}
}

\subsection{\emph{crayon} package}{

The \href{https://github.com/r-lib/crayon}{\emph{crayon}} package is required for
colored terminal output. If missing terminal output is monochrome.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("crayon")
}\if{html}{\out{</div>}}
}
}

\section{Database connection}{
There are different ways to open a connection and to get data.

Prepare database with a table

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupSQLite(dbname = tempfile()) # Setup SQLite database
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$writeTable("mtcars", mtcars) # Create table for testing
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Write table mtcars columns mpg, cyl, disp, hp, drat, wt, qsec, vs, am, gear, carb rows 32
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$disconnect() # Close connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\strong{Example 1}

Get query with automatic connection / disconnection

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- db$getQuery("SELECT * FROM mtcars;") # Get query
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected 
## DCtR | Send query 21 characters 
## DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes 
## DCtR | Rows fetched 32 
## DCtR | Has completed yes 
## DCtr | Clear result 
## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\strong{Example 2}

Get query with manual connection / disconnection

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output1 <- db$getQuery("SELECT * FROM mtcars;") # Get query 1
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters 
## DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes 
## DCtR | Rows fetched 32 
## DCtR | Has completed yes 
## DCtr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output2 <- db$getQuery("SELECT * FROM mtcars;", 15) # Get query 2
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters 
## DCtR | Fetch rows 15 -> Received 15 rows, 11 columns, 3416 bytes 
## DCtR | Rows fetched 15 
## DCtR | Has completed no 
## DCtR | Fetch rows 15 -> Received 15 rows, 11 columns, 3416 bytes 
## DCtR | Rows fetched 30 
## DCtR | Has completed no 
## DCtR | Fetch rows 15 -> Received 2 rows, 11 columns, 2184 bytes 
## DCtR | Rows fetched 32 
## DCtR | Has completed yes 
## DCtr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$disconnect() # Close connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\strong{Example 3}

Function getQuery() is a combination of functions sendQuery(), fetch()
and clearResult().

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$sendQuery("SELECT * FROM mtcars;") # Send query
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- db$fetch() # Fetch result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$clearResult() # Clean up result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$disconnect() # Close connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

Clean up

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver() # Reset database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}
}

\section{Password storage}{
Some efforts were undertaken to encrypt and to protect the password in
the private area of the class. The class stores the password hidden and
inaccessible. \strong{Please let me know, in case you discover a way how to
access the password!}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
#> dctr | New object
db$setupDriver( # Setup PostgreSQL database with stored password (password and user are hidden - default behavior)
  RPostgres::Postgres(),
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password",
  protect = c("password", "user")
)
#> Dctr | Driver load RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection 1; Password is stored in the class and does not need to be provided.
#> DCtr | Database connected
output1 <- db$getQuery("SELECT * FROM mtcars;") # Get query 1
#> DCtR | Send query 21 characters 
#> DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes 
#> DCtR | Rows fetched 32 
#> DCtR | Has completed yes 
#> DCtr | Clear result
db$disconnect() # Close connection 1
#> Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection 2; Password is stored in the class and does not need to be provided.
#> DCtr | Database connected
output2 <- db$getQuery("SELECT * FROM mtcars;") # Get query 2
#> DCtR | Send query 21 characters 
#> DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes 
#> DCtR | Rows fetched 32 
#> DCtR | Has completed yes 
#> DCtr | Clear result
db$disconnect() # Close connection 2
#> Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver() # Reset database handling object
#> dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}

In case you do not want to store the password in the class, you will
need to provide it each time a connection is opened.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
#> dctr | New object
db$setupDriver( # Setup PostgreSQL database without stored password
  RPostgres::Postgres(),
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres"
)
#> Dctr | Driver load RPostgres
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect(password = "password") # Open connection 1; Password needs to be provided.
#> DCtr | Database connected
output1 <- db$getQuery("SELECT * FROM mtcars;") # Get query 1
#> DCtR | Send query 21 characters 
#> DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes 
#> DCtR | Rows fetched 32 
#> DCtR | Has completed yes 
#> DCtr | Clear result
db$disconnect() # Close connection 1
#> Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect(password = "password") # Open connection 2; Password needs to be provided.
#> DCtr | Database connected
output2 <- db$getQuery("SELECT * FROM mtcars;") # Get query 2
#> DCtR | Send query 21 characters 
#> DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes 
#> DCtR | Rows fetched 32 
#> DCtR | Has completed yes 
#> DCtr | Clear result
db$disconnect() # Close connection 2
#> Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver() # Reset database handling object
#> dctr | Driver unload RPostgres
}\if{html}{\out{</div>}}
}

\section{\emph{DBI} objects}{
\emph{rocker} class encapsulates the \emph{DBI} objects driver, connection and
result. If required, these objects can be directly used with \emph{DBI}
functions. \strong{However, it is recommended to use this option with care!}
Direct usage of \emph{DBI} functions, may disrupt proper function of \emph{rocker}
class. Many \emph{DBI} functions are implemented in \emph{rocker} class. Whenever
possible, use the \emph{rocker} class functions.

Prepare object

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.drv # Empty driver
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## NULL
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.con # Empty connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## NULL
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.res # Empty result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## NULL
}\if{html}{\out{</div>}}
\subsection{DBIDriver-class}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupSQLite() # Setup SQLite database
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.drv # 'DBI' DBIDriver-class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <SQLiteDriver>
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$getInfoDrv() # 'rocker' class function
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver info 2.2.16 (driver.version), 3.39.2 (client.version)

## $driver.version
## [1] '2.2.16'
## 
## $client.version
## [1] '3.39.2'
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{DBI::dbGetInfo(db$.drv) # Direct usage of 'DBI' function on 'rocker' class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $driver.version
## [1] '2.2.16'
## 
## $client.version
## [1] '3.39.2'
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{RSQLite::dbGetInfo(db$.drv) # Direct usage of driver package, 'RSQLite', function on 'rocker' class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $driver.version
## [1] '2.2.16'
## 
## $client.version
## [1] '3.39.2'
}\if{html}{\out{</div>}}
}

\subsection{DBIConnection-class}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.con # 'DBI' DBIConnection-class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <SQLiteConnection>
##   Path: :memory:
##   Extensions: TRUE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$getInfoCon() # 'rocker' class function
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Connection info 3.39.2 (db.version), :memory: (dbname), NA (username), NA (host), NA (port)

## $db.version
## [1] "3.39.2"
## 
## $dbname
## [1] ":memory:"
## 
## $username
## [1] NA
## 
## $host
## [1] NA
## 
## $port
## [1] NA
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{DBI::dbGetInfo(db$.con) # Direct usage of 'DBI' function on 'rocker' class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $db.version
## [1] "3.39.2"
## 
## $dbname
## [1] ":memory:"
## 
## $username
## [1] NA
## 
## $host
## [1] NA
## 
## $port
## [1] NA
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{RSQLite::dbGetInfo(db$.con) # Direct usage of driver package, 'RSQLite', function on 'rocker' class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $db.version
## [1] "3.39.2"
## 
## $dbname
## [1] ":memory:"
## 
## $username
## [1] NA
## 
## $host
## [1] NA
## 
## $port
## [1] NA
}\if{html}{\out{</div>}}

Prepare table

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$writeTable("mtcars", mtcars) # Create table for testing
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Write table mtcars columns mpg, cyl, disp, hp, drat, wt, qsec, vs, am, gear, carb rows 32
}\if{html}{\out{</div>}}
}

\subsection{DBIResult-class}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$sendQuery("SELECT * FROM mtcars;") # Send query
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.res # 'DBI' DBIResult-class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <SQLiteResult>
##   SQL  SELECT * FROM mtcars;
##   ROWS Fetched: 0 [incomplete]
##        Changed: 0
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$getInfoRes() # 'rocker' class function
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Result info SELECT * FROM mtcars; (statement), 0 (row.count), 0 (rows.affected), FALSE (has.completed)

## $statement
## [1] "SELECT * FROM mtcars;"
## 
## $row.count
## [1] 0
## 
## $rows.affected
## [1] 0
## 
## $has.completed
## [1] FALSE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{DBI::dbGetInfo(db$.res) # Direct usage of 'DBI' function on 'rocker' class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $statement
## [1] "SELECT * FROM mtcars;"
## 
## $row.count
## [1] 0
## 
## $rows.affected
## [1] 0
## 
## $has.completed
## [1] FALSE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{RSQLite::dbGetInfo(db$.res) # Direct usage of driver package, 'RSQLite', function on 'rocker' class
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## $statement
## [1] "SELECT * FROM mtcars;"
## 
## $row.count
## [1] 0
## 
## $rows.affected
## [1] 0
## 
## $has.completed
## [1] FALSE
}\if{html}{\out{</div>}}

Clean up

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$clearResult() # Clean up result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.res # Empty result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## NULL
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$disconnect() # Close connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.con # Empty connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## NULL
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver() # Reset database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$.drv # Empty driver
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## NULL
}\if{html}{\out{</div>}}
}
}

\section{\emph{DBI} functions in \emph{rocker}}{
Generally, \emph{rocker} function names are related to \emph{DBI} function names.
In \emph{rocker} functions, the leading \strong{db} is removed.

In \emph{DBI} most functions need to be supplied with a driver
\if{html}{\out{<sup>}}(drv)\if{html}{\out{</sup>}}, connection \if{html}{\out{<sup>}}(conn)\if{html}{\out{</sup>}} or result
\if{html}{\out{<sup>}}(res)\if{html}{\out{</sup>}} object. In \emph{rocker}, functions automatically access the
corresponding objects \if{html}{\out{<sup>}}(.drv,\if{html}{\out{</sup>}} \if{html}{\out{<sup>}}.con\if{html}{\out{</sup>}} \if{html}{\out{<sup>}}and\if{html}{\out{</sup>}}
\if{html}{\out{<sup>}}.res)\if{html}{\out{</sup>}} stored in the class.

\strong{\emph{DBI} example}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{drv <- RSQLite::SQLite() # SQLite driver
DBI::dbCanConnect( # Test parameter
  drv = drv,
  dbname = ":memory:"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] TRUE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{con <- DBI::dbConnect( # Open connection
  drv = drv,
  dbname = ":memory:"
)
DBI::dbWriteTable(con, "mtcars", mtcars) # Create table for testing
res <- DBI::dbSendQuery(con, "SELECT * FROM mtcars;") # Send query
output <- DBI::dbFetch(res) # Fetch result
DBI::dbClearResult(res) # Clean up result
DBI::dbDisconnect(con) # Close connection
DBI::dbUnloadDriver(drv) # Unload driver
}\if{html}{\out{</div>}}

\strong{\emph{rocker} example}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB(verbose = FALSE) # New database handling object
db$setupDriver( # Setup SQLite database
  drv = RSQLite::SQLite(),
  dbname = ":memory:"
)
db$canConnect() # Test parameter
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] TRUE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection
db$writeTable("mtcars", mtcars) # Create table for testing
db$sendQuery("SELECT * FROM mtcars;") # Send query
output <- db$fetch() # Fetch result
db$clearResult() # Clean up result
db$disconnect() # Close connection
db$unloadDriver() # Reset database handling object
}\if{html}{\out{</div>}}
\subsection{List of functions}{\tabular{llll}{
   \emph{rocker} function \tab Corresponding \emph{DBI} function \tab \emph{DBI} object used \tab Comment \cr
   initialize() \tab \emph{none} \tab \emph{none} \tab  \cr
   print() \tab \emph{none} \tab \emph{none} \tab  \cr
   setupDriver() \tab \emph{none} \tab \emph{driver from appropriate package} \tab Usually, parameters provided to dbConnect() in \emph{DBI} are provided to setupDriver() in \emph{rocker} \cr
   setupPostgreSQL() \tab \emph{none} \tab \emph{none} \tab RPostgres::Postgres() is used with \emph{rocker} function setupDriver() \cr
   setupMariaDB() \tab \emph{none} \tab \emph{none} \tab RMariaDB::MariaDB() is used with \emph{rocker} function setupDriver() \cr
   setupSQLite() \tab \emph{none} \tab \emph{none} \tab RSQLite::SQLite() is used with \emph{rocker} function setupDriver() \cr
   unloadDriver() \tab dbUnloadDriver() \tab driver \tab  \cr
   canConnect() \tab dbCanConnect() \tab driver \tab Usually, parameters provided to dbCanConnect() in \emph{DBI} are provided to setupDriver() in \emph{rocker} \cr
   connect() \tab dbConnect() \tab driver \tab Usually, parameters provided to dbConnect() in \emph{DBI} are provided to setupDriver() in \emph{rocker} \cr
   disconnect() \tab dbDisconnect() \tab connection \tab  \cr
   sendQuery() \tab dbSendQuery() \tab connection \tab  \cr
   getQuery() \tab Is \strong{not} using dbGetQuery(), but has the same function \tab connection \tab Especially, combination of \emph{rocker} functions sendQuery(), fetch() and clearResult() \cr
   sendStatement() \tab dbSendStatement() \tab connection \tab  \cr
   execute() \tab Is \strong{not} using dbExecute(), but has the same function \tab connection \tab Especially, combination of \emph{rocker} functions sendStatement() and clearResult() \cr
   fetch() \tab dbFetch() \tab result \tab  \cr
   hasCompleted() \tab dbHasCompleted() \tab result \tab  \cr
   getRowsAffected() \tab dbGetRowsAffected() \tab result \tab  \cr
   getRowCount() \tab dbGetRowCount() \tab result \tab  \cr
   columnInfo() \tab dbColumnInfo() \tab result \tab  \cr
   getStatement() \tab dbGetStatement() \tab result \tab  \cr
   clearResult() \tab dbClearResult() \tab result \tab  \cr
   begin() \tab dbBegin() \tab connection \tab  \cr
   commit() \tab dbCommit() \tab connection \tab  \cr
   rollback() \tab dbRollback() \tab connection \tab  \cr
   getInfoDrv() \tab dbGetInfo() \tab driver \tab  \cr
   getInfoCon() \tab dbGetInfo() \tab connection \tab  \cr
   getInfoRes() \tab dbGetInfo() \tab result \tab  \cr
   isValidDrv() \tab dbIsValid() \tab driver \tab  \cr
   isValidCon() \tab dbIsValid() \tab connection \tab  \cr
   isValidRes() \tab dbIsValid() \tab result \tab  \cr
   createTable() \tab dbCreateTable() \tab connection \tab  \cr
   appendTable() \tab dbAppendTable() \tab connection \tab  \cr
   writeTable() \tab dbWriteTable \tab connection \tab  \cr
   readTable() \tab dbReadTable \tab connection \tab  \cr
   removeTable() \tab dbRemoveTable() \tab connection \tab  \cr
   existsTable() \tab dbExistsTable() \tab connection \tab  \cr
   listFields() \tab dbListFields() \tab connection \tab  \cr
   listObjects() \tab dbListObjects() \tab connection \tab  \cr
   listTables() \tab dbListTables() \tab connection \tab  \cr
}

}
}

\section{Transaction}{
Setup database and a table with 32 rows.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB() # New database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupSQLite() # Setup SQLite database
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect() # Open connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$writeTable("mtcars", mtcars) # Create table for testing
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Write table mtcars columns mpg, cyl, disp, hp, drat, wt, qsec, vs, am, gear, carb rows 32
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- db$getQuery("SELECT * FROM mtcars;") # Get query -> 32 rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters 
## DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes 
## DCtR | Rows fetched 32 
## DCtR | Has completed yes 
## DCtr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$transaction # Transaction indicator
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] FALSE
}\if{html}{\out{</div>}}

Starting with a table with 32 rows, begin transaction 1. Delete 15 rows
and commit transaction. Operations results in a table with 17 rows.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$begin() # Start transaction 1
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCTr | Transaction begin
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$transaction # Transaction indicator
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] TRUE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{AFFECTED <- db$execute("DELETE FROM mtcars WHERE gear = 3;") # Modify table -> 15 rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCTR | Send statement 34 characters 
## DCTR | Rows affected 15 
## DCTr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$commit() # Commit transaction 1
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Transaction commit
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$transaction # Transaction indicator
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] FALSE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- db$getQuery("SELECT * FROM mtcars;") # Get query -> 17 rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters 
## DCtR | Fetch rows all -> Received 17 rows, 11 columns, 3504 bytes 
## DCtR | Rows fetched 17 
## DCtR | Has completed yes 
## DCtr | Clear result
}\if{html}{\out{</div>}}

Starting with a table with 17 rows, begin transaction 2. Delete 5 rows
and rollback transaction. Operations results in a table with 17 rows.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$begin() # Start transaction 2
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCTr | Transaction begin
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$transaction # Transaction indicator
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] TRUE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{AFFECTED <- db$execute("DELETE FROM mtcars WHERE gear = 5;") # Modify table -> 5 rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCTR | Send statement 34 characters 
## DCTR | Rows affected 5 
## DCTr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- db$getQuery("SELECT * FROM mtcars;") # Get query -> 12 rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCTR | Send query 21 characters 
## DCTR | Fetch rows all -> Received 12 rows, 11 columns, 3416 bytes 
## DCTR | Rows fetched 12 
## DCTR | Has completed yes 
## DCTr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$rollback() # Rollback transaction 2
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Transaction rollback
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$transaction # Transaction indicator
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] FALSE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- db$getQuery("SELECT * FROM mtcars;") # Get query -> 17 rows
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters 
## DCtR | Fetch rows all -> Received 17 rows, 11 columns, 3504 bytes 
## DCtR | Rows fetched 17 
## DCtR | Has completed yes 
## DCtr | Clear result
}\if{html}{\out{</div>}}

Clean up

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$disconnect() # Close connection
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver() # Reset database handling object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}
}

\section{Usage of S3 and R6 functions}{
Although \emph{rocker} is a \emph{R6} class, functions can be also accesses in
classical S3 way.

\strong{S3 example}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(rocker)
db <- newDB()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{setupDriver(db, drv = RSQLite::SQLite(), dbname = ":memory:")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{connect(db)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{writeTable(db, "mtcars", mtcars)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Write table mtcars columns mpg, cyl, disp, hp, drat, wt, qsec, vs, am, gear, carb rows 32
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sendQuery(db, "SELECT * FROM mtcars;")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- fetch(db)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{clearResult(db)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{disconnect(db)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{unloadDriver(db)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}

\strong{R6 example}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db <- rocker::newDB()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | New object
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$setupDriver(drv = RSQLite::SQLite(), dbname = ":memory:")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Driver load RSQLite
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$connect()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Database connected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$writeTable("mtcars", mtcars)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Write table mtcars columns mpg, cyl, disp, hp, drat, wt, qsec, vs, am, gear, carb rows 32
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$sendQuery("SELECT * FROM mtcars;")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Send query 21 characters
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{output <- db$fetch()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtR | Fetch rows all -> Received 32 rows, 11 columns, 4824 bytes
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$clearResult()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## DCtr | Clear result
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$disconnect()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Dctr | Database disconnected
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{db$unloadDriver()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## dctr | Driver unload RSQLite
}\if{html}{\out{</div>}}
}

\seealso{
Other rocker: 
\code{\link{newDB}()},
\code{\link{rocker-R6-class}},
\code{\link{rocker-S3-functions}},
\code{\link{rocker-package}}

Other rocker-S3-functions: 
\code{\link{appendTable}()},
\code{\link{begin}()},
\code{\link{canConnect}()},
\code{\link{clearResult}()},
\code{\link{columnInfo}()},
\code{\link{commit}()},
\code{\link{connect}()},
\code{\link{createTable}()},
\code{\link{disconnect}()},
\code{\link{execute}()},
\code{\link{existsTable}()},
\code{\link{fetch}()},
\code{\link{getInfoCon}()},
\code{\link{getInfoDrv}()},
\code{\link{getInfoRes}()},
\code{\link{getQuery}()},
\code{\link{getRowCount}()},
\code{\link{getRowsAffected}()},
\code{\link{getStatement}()},
\code{\link{hasCompleted}()},
\code{\link{isValidCon}()},
\code{\link{isValidDrv}()},
\code{\link{isValidRes}()},
\code{\link{listFields}()},
\code{\link{listObjects}()},
\code{\link{listTables}()},
\code{\link{readTable}()},
\code{\link{removeTable}()},
\code{\link{rocker-S3-functions}},
\code{\link{rocker-package}},
\code{\link{rollback}()},
\code{\link{sendQuery}()},
\code{\link{sendStatement}()},
\code{\link{setupDriver}()},
\code{\link{setupMariaDB}()},
\code{\link{setupPostgreSQL}()},
\code{\link{setupSQLite}()},
\code{\link{unloadDriver}()},
\code{\link{validateCon}()},
\code{\link{writeTable}()}
}
\concept{rocker}
\concept{rocker-S3-functions}
