% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{count_indices}
\alias{count_indices}
\title{Counts the number of times each index was sampled}
\usage{
count_indices(resamples, indices)
}
\arguments{
\item{resamples}{A list of resamples, as created by \link{nonparametric}.}

\item{indices}{The vector of original indices from which the resamples were
drawn.}
}
\value{
\code{count_indices} returns a list with two names elements. Each
element is a matrix that stores how often each observation/index was
resampled (column) for each resample (row). \code{$count_clean} only has
columns for observations that were available in the indices.
\code{$count_all} counts the occurrence of all indices in the range of
indices that were provided, even if the index was actually not available in
the given indices. These are of course zero since they were not available for
resampling. If the given indices do not skip any numbers, the two coincide.
}
\description{
\code{count_indices} takes a list of indices for resampling and counts how
often each index was sampled in each resample. The result is returned in two
versions of a matrix where each row corresponds to a different resample and
each column to one index.
}
