% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_inf_test.R
\name{beta_test_avar}
\alias{beta_test_avar}
\title{Calculates the asymptotic variance of the difference between robust and full
sample estimators of the structural parameters}
\usage{
beta_test_avar(robust2sls_object, iteration, fp = FALSE)
}
\arguments{
\item{robust2sls_object}{An object of class \code{"robust2sls"}.}

\item{iteration}{An integer > 0 specifying the iteration step for which
parameters to calculate corrected standard errors.}

\item{fp}{A logical value whether the fixed point asymptotic variance
(TRUE) or the exact iteration asymptotic variance should be computed (FALSE).}
}
\value{
\code{beta_test_avar} returns a dx by dx variance-covariance matrix of
the difference between the robust and full sample structural parameter
estimates of the 2SLS model.
}
\description{
Calculates the asymptotic variance of the difference between robust and full
sample estimators of the structural parameters
}
\details{
Argument \code{fp} determines whether the fixed point asymptotic variance
should be computed. This argument is only respected if the specified
\code{iteration} is one of the iterations after the algorithm converged.
}
