% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GxESelection.R
\name{GxESelection}
\alias{GxESelection}
\alias{GxESelection.Sparse}
\alias{GxESelection.NonSparse}
\title{Variable selection for a roben object}
\usage{
GxESelection(obj, ...)

\method{GxESelection}{Sparse}(obj, burn.in = obj$burn.in, ...)

\method{GxESelection}{NonSparse}(obj, burn.in = obj$burn.in, prob = 0.95, ...)
}
\arguments{
\item{obj}{roben object.}

\item{...}{other GxESelection arguments.}

\item{burn.in}{MCMC burn-in.}

\item{prob}{probability for credible interval, between 0 and 1. e.g. prob=0.95 leads to 95\% credible interval.}
}
\value{
an object of class `GxESelection' is returned, which is a list with components:
\itemize{
\item method: method used for identifying important effects.
\item effects: a list of names of selected effects.
\item summary: a summary of selected effects.
\item indicator: a matrix of indicators of selected effects.
}
}
\description{
Variable selection for a roben object
}
\details{
For class `Sparse', the median probability model (MPM) (Barbieri and Berger, 2004) is used to identify predictors that are significantly associated
with the response variable. For class `NonSparse', variable selection is based on 95\% credible interval.
Please check the references for more details about the variable selection.
}
\examples{
data(GxE_small)
iter=5000
## sparse
fit=roben(X, Y, E, clin, iterations=iter)
selected=GxESelection(fit)
selected

\donttest{
## non-sparse
fit=roben(X, Y, E, clin, iterations=iter, sparse=FALSE)
selected=GxESelection(fit)
selected
}

}
\references{
Ren, J., Zhou, F., Li, X., Ma, S., Jiang, Y. and Wu, C. (2023) Robust Bayesian variable selection for
gene-environment interactions. \emph{Biometrics}, 79(2):684-694. \doi{10.1111/biom.13670}. PMID: 35394058.

Barbieri, M.M. and Berger, J.O. (2004). Optimal predictive model selection. {\emph{Ann. Statist}, 32(3):870–897}
}
\seealso{
\code{\link{roben}}
}
