/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.cutoffMethods;

import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.measuresRI.Importance;
import dmLab.mcfs.cutoffMethods.ContrastCutoff;
import dmLab.mcfs.cutoffMethods.CriticalAngleCutoff;
import dmLab.mcfs.cutoffMethods.CutoffMethod;
import dmLab.mcfs.cutoffMethods.KMeansCutoff;
import dmLab.utils.MathUtils;
import dmLab.utils.dataframe.DataFrame;
import java.util.Arrays;

public final class Cutoff {
    private CutoffMethod[] cutoffMethod;
    private DataFrame cutoffTable;
    private MCFSParams mcfsParams;

    /*
     * WARNING - void declaration
     */
    public Cutoff(MCFSParams mcfsParams) {
        void var1_1;
        void var2_2;
        int methodsNum = this.initCutoffMethods(mcfsParams);
        this.cutoffTable = new DataFrame((int)var2_2, 4);
        this.cutoffTable.setColNames(new String[]{"method", "minRI", "size", "minID"});
        short[] sArray = new short[4];
        sArray[1] = 1;
        sArray[2] = 1;
        sArray[3] = 1;
        this.cutoffTable.setColTypes(sArray);
        this.mcfsParams = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int initCutoffMethods(MCFSParams mcfsParams) {
        if (mcfsParams.cutoffMethod.equalsIgnoreCase("contrast")) {
            this.cutoffMethod = new CutoffMethod[3];
            this.cutoffMethod[0] = new CriticalAngleCutoff(mcfsParams);
            this.cutoffMethod[1] = new KMeansCutoff(mcfsParams);
            this.cutoffMethod[2] = new ContrastCutoff(mcfsParams);
        } else {
            void var1_1;
            this.cutoffMethod = new CutoffMethod[2];
            this.cutoffMethod[0] = new CriticalAngleCutoff(mcfsParams);
            this.cutoffMethod[1] = new KMeansCutoff((MCFSParams)var1_1);
        }
        return this.cutoffMethod.length;
    }

    /*
     * WARNING - void declaration
     */
    public final double calcCutoff(AttributesRI attrRI) {
        void var1_1;
        int methodsNum = this.initCutoffMethods(this.mcfsParams);
        Object[] importance = attrRI.getImportances(attrRI.mainMeasureIdx);
        Arrays.sort(importance);
        double[] minRI = new double[methodsNum];
        double[] attrNumber = new double[methodsNum];
        int i = 0;
        while (i < this.cutoffMethod.length) {
            double d;
            block3: {
                minRI[i] = this.cutoffMethod[i].getCutoff((Importance[])importance);
                double d2 = minRI[i];
                Object[] objectArray = importance;
                int n = 0;
                while (n < objectArray.length) {
                    if (((Importance)objectArray[n]).importance < d2) {
                        d = n;
                        break block3;
                    }
                    ++n;
                }
                d = Double.NaN;
            }
            attrNumber[i] = d;
            this.cutoffTable.set(i, this.cutoffTable.getColIdx("method"), this.cutoffMethod[i].name);
            this.cutoffTable.set(i, this.cutoffTable.getColIdx("minRI"), minRI[i]);
            this.cutoffTable.set(i, this.cutoffTable.getColIdx("size"), attrNumber[i]);
            ++i;
        }
        double d = this.addMeanValue((AttributesRI)var1_1);
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public final double addMeanValue(AttributesRI attrRI) {
        void var1_1;
        Object[] importance = attrRI.getImportances(attrRI.mainMeasureIdx);
        Arrays.sort(importance);
        Object[] objectArray = this.cutoffTable.getColumn(this.cutoffTable.getColIdx("size"));
        double[] dArray = new double[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            dArray[n] = objectArray[n] == null ? Double.NaN : (Double)objectArray[n];
            ++n;
        }
        objectArray = dArray;
        double mean_attrNumber = Math.round(MathUtils.mean(dArray));
        double mean_minRI = ((Importance)importance[(int)mean_attrNumber]).importance;
        DataFrame meanRow = new DataFrame(1, this.cutoffTable);
        meanRow.set(0, meanRow.getColIdx("method"), "mean");
        meanRow.set(0, meanRow.getColIdx("minRI"), mean_minRI);
        meanRow.set(0, meanRow.getColIdx("size"), mean_attrNumber);
        this.cutoffTable.rbind((DataFrame)var1_1);
        return mean_minRI;
    }

    public final DataFrame getCutoffTable() {
        return this.cutoffTable;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCutoffTable(DataFrame cutoffTable) {
        void var1_1;
        this.cutoffTable = var1_1;
    }

    public final String toString() {
        return this.cutoffTable.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final float getCutoffValue(String method) {
        void var1_2;
        void var2_4;
        int colIdx = this.cutoffTable.getColIdx("method");
        int rowIdx = this.cutoffTable.getFirstRowIdx((int)var2_4, this.getMethod(method));
        float f = ((Double)this.cutoffTable.get((int)var1_2, this.cutoffTable.getColIdx("size"))).floatValue();
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public final String getMethod(String method) {
        void var1_1;
        void var2_2;
        int colIdx = this.cutoffTable.getColIdx("method");
        int rowIdx = this.cutoffTable.getFirstRowIdx(colIdx, method);
        if (var2_2 == -1) {
            String resultMethod = "mean";
        }
        return var1_1;
    }
}

